/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.core;

import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osee.framework.ui.branch.graph.Activator;
import org.eclipse.osee.framework.ui.branch.graph.core.BranchGraphEditor;
import org.eclipse.osee.framework.ui.branch.graph.parts.GraphEditPart;
import org.eclipse.osee.framework.ui.branch.graph.utility.GraphOptions;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;

public class BranchGraphActionBarContributor
extends ActionBarContributor {
    private BranchGraphEditor editor;
    private static ToggleFilterConnectionAction[] toggleFilterConnectionAction;
    private static ToggleTxFilterAction[] toggleTxFilterAction;

    public void setActiveEditor(IEditorPart editor) {
        super.setActiveEditor(editor);
        this.editor = (BranchGraphEditor)editor;
    }

    protected void buildActions() {
    }

    protected void declareGlobalActionKeys() {
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new ZoomComboContributionItem((IPartService)this.getPage()));
        toolBarManager.add((IContributionItem)new Separator());
        toggleFilterConnectionAction = new ToggleFilterConnectionAction[]{new ToggleFilterConnectionAction("None", GraphOptions.ConnectionFilter.NO_FILTER), new ToggleFilterConnectionAction("Filter All Connections", GraphOptions.ConnectionFilter.FILTER_ALL_CONNECTIONS), new ToggleFilterConnectionAction("Filter Branch Hierarchy Connections", GraphOptions.ConnectionFilter.FILTER_CHILD_BRANCH_CONNECTIONS), new ToggleFilterConnectionAction("Filter Merge Connections", GraphOptions.ConnectionFilter.FILTER_MERGE_CONNECTIONS)};
        toolBarManager.add((IAction)new FilterConnectionAction());
        toggleTxFilterAction = new ToggleTxFilterAction[]{new ToggleTxFilterAction("Show All", GraphOptions.TxFilter.NO_FILTER), new ToggleTxFilterAction("Hide All", GraphOptions.TxFilter.HIDE_ALL)};
        toolBarManager.add((IAction)new FilterTxAction());
    }

    private static final class FilterConnectionAction
    extends Action
    implements IMenuCreator {
        private Menu menu;

        public FilterConnectionAction() {
            this.setText("Filter connections");
            this.setToolTipText("Filter connections");
            this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.FILTERS));
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            int index = 0;
            while (index < toggleFilterConnectionAction.length) {
                this.addActionToMenu(this.menu, toggleFilterConnectionAction[index]);
                ++index;
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        private void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }
    }

    private static final class FilterTxAction
    extends Action
    implements IMenuCreator {
        private Menu menu;

        public FilterTxAction() {
            this.setText("Filter transactions");
            this.setToolTipText("Filter transactions");
            this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.DB_ICON_BLUE));
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            int index = 0;
            while (index < toggleTxFilterAction.length) {
                this.addActionToMenu(this.menu, toggleTxFilterAction[index]);
                ++index;
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        private void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }
    }

    private final class ToggleFilterConnectionAction
    extends Action {
        private final GraphOptions.ConnectionFilter show;

        public ToggleFilterConnectionAction(String text, GraphOptions.ConnectionFilter show) {
            super(text, 8);
            this.show = show;
            this.setChecked(show.ordinal() == Activator.getInstance().getPreferenceStore().getInt("revision.graph.filter.connections"));
        }

        public void run() {
            if (this.isChecked()) {
                Activator.getInstance().getPreferenceStore().setValue("revision.graph.filter.connections", this.show.ordinal());
                GraphEditPart graphEditPart = (GraphEditPart)BranchGraphActionBarContributor.this.editor.getViewer().getContents();
                graphEditPart.setConnectionVisibility();
            }
        }
    }

    private final class ToggleTxFilterAction
    extends Action {
        private final GraphOptions.TxFilter show;

        public ToggleTxFilterAction(String text, GraphOptions.TxFilter show) {
            super(text, 8);
            this.show = show;
            this.setChecked(show.ordinal() == Activator.getInstance().getPreferenceStore().getInt("revision.graph.show.all.transactions"));
        }

        public void run() {
            if (this.isChecked()) {
                Activator.getInstance().getPreferenceStore().setValue("revision.graph.show.all.transactions", this.show.ordinal());
                GraphEditPart graphEditPart = (GraphEditPart)BranchGraphActionBarContributor.this.editor.getViewer().getContents();
                graphEditPart.setTxVisibility();
            }
        }
    }
}

