/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.operations;

import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.operations.TraceResourceDropOperation;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UiRenameConfirmer
implements TraceResourceDropOperation.RenameConfirmer {
    @Override
    public boolean acceptUpdate(final Map<Artifact, String> nameUpdateRequired) {
        final MutableBoolean result = new MutableBoolean(false);
        if (nameUpdateRequired != null && !nameUpdateRequired.isEmpty()) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageDialog dialog = UiRenameConfirmer.this.createDialog(nameUpdateRequired);
                        int value = dialog.open();
                        result.setValue(value == 0);
                    }
                    catch (Throwable ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error during UI rename", (Throwable)ex);
                        result.setValue(false);
                    }
                }
            }, (boolean)true);
        } else {
            result.setValue(true);
        }
        return result.getValue();
    }

    private MessageDialog createDialog(Map<Artifact, String> nameUpdateRequired) {
        XTableDialog dialog = new XTableDialog(Displays.getActiveShell(), "Rename Artifacts", null, "The following artifacts will be renamed.\n\n Select OK to continue with rename or Cancel to abort.", 5, new String[]{"Ok", "Cancel"}, 0, nameUpdateRequired);
        return dialog;
    }

    private static final class XTable
    extends XViewer {
        public XTable(Composite parent, int style) {
            super(parent, style, (IXViewerFactory)new XTableFactory());
        }
    }

    public static final class XTableContentProvider
    extends ArrayTreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Map) {
                return ((Map)parentElement).entrySet().toArray();
            }
            if (parentElement instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)parentElement;
                return new Object[]{entry.getKey(), entry.getValue()};
            }
            return new Object[0];
        }
    }

    private static final class XTableDialog
    extends MessageDialog {
        private final Map<Artifact, String> nameUpdateRequired;

        public XTableDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, Map<Artifact, String> nameUpdateRequired) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.nameUpdateRequired = nameUpdateRequired;
        }

        protected Control createCustomArea(Composite parent) {
            Composite area = new Composite(parent, 2048);
            area.setLayout((Layout)new GridLayout());
            area.setLayoutData((Object)new GridData(4, 4, true, true));
            XTable table = new XTable(area, 66306);
            table.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
            table.setContentProvider((IContentProvider)new XTableContentProvider());
            table.setLabelProvider((IBaseLabelProvider)new XTableLabelProvider(table));
            table.setInput(this.nameUpdateRequired);
            return area;
        }
    }

    private static final class XTableFactory
    extends XViewerFactory {
        private static String COLUMN_NAMESPACE = "xviewer.rename.dialog.table";
        public static XViewerColumn FROM_NAME_COLUMN = new XViewerColumn(String.valueOf(COLUMN_NAMESPACE) + ".from.name", "From Name", 200, XViewerAlign.Left, true, SortDataType.String, false, null);
        public static XViewerColumn TO_NAME_COLUMN = new XViewerColumn(String.valueOf(COLUMN_NAMESPACE) + ".to.name", "To Name", 200, XViewerAlign.Left, true, SortDataType.String, false, null);

        public XTableFactory() {
            super(COLUMN_NAMESPACE);
            this.registerColumns(new XViewerColumn[]{FROM_NAME_COLUMN, TO_NAME_COLUMN});
        }

        public boolean isAdmin() {
            return false;
        }
    }

    private static final class XTableLabelProvider
    extends XViewerLabelProvider {
        public XTableLabelProvider(XViewer xViewer) {
            super(xViewer);
        }

        public String getColumnText(Object element, XViewerColumn xCol, int columnIndex) {
            Map.Entry item = (Map.Entry)element;
            if (xCol.equals((Object)XTableFactory.FROM_NAME_COLUMN)) {
                return ((Artifact)item.getKey()).getSafeName();
            }
            if (xCol.equals((Object)XTableFactory.TO_NAME_COLUMN)) {
                return (String)item.getValue();
            }
            return "unhandled column";
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
            return null;
        }
    }
}

