/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osee.define.ide.traceability.data.BaseTraceDataCache;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class TestUnitData
extends BaseTraceDataCache {
    private final List<Artifact> testCases;
    private final List<Artifact> testProcedures;
    private final List<Artifact> testSupportItems;
    private final Set<Artifact> allTestUnits;
    private final HashMap<String, Artifact> testCaseMap = new HashMap();
    private final HashMap<String, Artifact> testProcedureMap = new HashMap();
    private final HashMap<String, Artifact> testSupportMap = new HashMap();

    public TestUnitData(BranchId branch) {
        super("Test Unit Data", branch);
        this.testCases = new ArrayList<Artifact>();
        this.testProcedures = new ArrayList<Artifact>();
        this.testSupportItems = new ArrayList<Artifact>();
        this.allTestUnits = new TreeSet<Artifact>();
    }

    @Override
    public void reset() {
        super.reset();
        this.testCaseMap.clear();
        this.testProcedureMap.clear();
        this.testSupportMap.clear();
        this.testCases.clear();
        this.testProcedures.clear();
        this.testSupportItems.clear();
        this.allTestUnits.clear();
    }

    @Override
    protected void doBulkLoad(IProgressMonitor monitor) throws Exception {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        this.testCases.addAll(ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.TestCase, (BranchId)this.getBranch()));
        this.populateTraceMap(monitor, this.testCases, this.testCaseMap);
        subMonitor.worked(20);
        if (!monitor.isCanceled()) {
            monitor.subTask(String.format("Load Test Support from: [%s]", this.getBranch()));
            this.testSupportItems.addAll(ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.TestSupport, (BranchId)this.getBranch()));
            this.populateTraceMap(monitor, this.testSupportItems, this.testSupportMap);
            subMonitor.worked(20);
        }
        if (!monitor.isCanceled()) {
            monitor.subTask(String.format("Load Test Procedures from: [%s]", this.getBranch()));
            this.testProcedures.addAll(ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.TestProcedure, (BranchId)this.getBranch()));
            this.testProcedures.addAll(ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.TestProcedureWholeWord, (BranchId)this.getBranch()));
            this.populateTraceMap(monitor, this.testProcedures, this.testProcedureMap);
            subMonitor.worked(20);
        }
        if (!monitor.isCanceled()) {
            this.allTestUnits.addAll(this.testCases);
            this.allTestUnits.addAll(this.testProcedures);
            this.allTestUnits.addAll(this.testSupportItems);
            subMonitor.worked(1);
        }
    }

    public Collection<Artifact> getTestCases() {
        return this.testCases;
    }

    public Collection<Artifact> getTestSupportItems() {
        return this.testSupportItems;
    }

    public Collection<Artifact> getTestProcedures() {
        return this.testProcedures;
    }

    public Set<Artifact> getAllTestUnits() {
        return this.allTestUnits;
    }

    public Artifact getTestUnitByName(String testUnitName) {
        Artifact testUnit = this.testCaseMap.get(testUnitName);
        if (testUnit == null) {
            testUnit = this.testSupportMap.get(testUnitName);
        }
        if (testUnit == null) {
            testUnit = this.testProcedureMap.get(testUnitName);
        }
        return testUnit;
    }
}

