/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.traceability.TraceabilityExtractor;
import org.eclipse.osee.define.ide.traceability.data.BaseTraceDataCache;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.utility.ViewIdUtility;

public class RequirementData
extends BaseTraceDataCache {
    private static final TraceabilityExtractor traceExtractor = TraceabilityExtractor.getInstance();
    private final List<Artifact> directRequirements = new ArrayList<Artifact>();
    private final HashMap<String, Artifact> allRequirementsMap = new HashMap();
    private final TraceabilityExtractor extractor = TraceabilityExtractor.getInstance();
    private final Collection<? extends ArtifactTypeToken> types;
    private final boolean withInheritance;
    private final ArtifactId viewId;

    public RequirementData(BranchId branch, Collection<? extends ArtifactTypeToken> types, boolean withInheritance, ArtifactId viewId) {
        super("Software Requirements Data", branch);
        this.types = types;
        this.withInheritance = withInheritance;
        this.viewId = viewId;
    }

    public RequirementData(BranchId branch, ArtifactId viewId) {
        super("Software Requirements Data", branch);
        this.types = Collections.singleton(CoreArtifactTypes.AbstractSoftwareRequirement);
        this.withInheritance = true;
        this.viewId = viewId;
    }

    @Override
    public void reset() {
        super.reset();
        this.directRequirements.clear();
        this.allRequirementsMap.clear();
    }

    @Override
    protected void doBulkLoad(IProgressMonitor monitor) throws Exception {
        Set excludedArtifactIdMap = new HashSet();
        excludedArtifactIdMap = ViewIdUtility.findExcludedArtifactsByView((ArtifactId)this.viewId, (BranchId)this.getBranch());
        ArrayList<Artifact> allSwRequirements = new ArrayList<Artifact>();
        for (ArtifactTypeToken artifactTypeToken : this.types) {
            if (this.withInheritance) {
                allSwRequirements.addAll(ArtifactQuery.getArtifactListFromTypeWithInheritence((ArtifactTypeToken)artifactTypeToken, (BranchId)this.getBranch(), (DeletionFlag)DeletionFlag.EXCLUDE_DELETED));
                continue;
            }
            allSwRequirements.addAll(ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)artifactTypeToken, (BranchId)this.getBranch(), (DeletionFlag)DeletionFlag.EXCLUDE_DELETED));
        }
        ViewIdUtility.removeExcludedArtifacts(allSwRequirements.iterator(), excludedArtifactIdMap);
        this.populateTraceMap(monitor, allSwRequirements, this.allRequirementsMap);
        for (Artifact artifact : this.getAllRequirements()) {
            if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.IndirectSoftwareRequirementMsWord})) continue;
            this.directRequirements.add(artifact);
        }
        monitor.worked(38);
    }

    @Override
    protected String asTraceMapKey(Artifact artifact) {
        return traceExtractor.getCanonicalRequirementName(artifact.getName());
    }

    public Collection<Artifact> getDirectRequirements() {
        return this.directRequirements;
    }

    public Collection<Artifact> getAllRequirements() {
        return this.allRequirementsMap.values();
    }

    public Artifact getRequirementFromTraceMark(String traceMark) {
        return this.allRequirementsMap.get(this.extractor.getCanonicalRequirementName(traceMark));
    }

    public Artifact getRequirementFromArtifactId(ArtifactId artId) {
        for (Artifact art : this.directRequirements) {
            if (!art.equals((Object)artId)) continue;
            return art;
        }
        return null;
    }

    public Artifact getRequirementFromTraceMarkIncludeStructuredRequirements(String traceMark) {
        Pair<String, String> structured;
        Artifact toReturn = this.getRequirementFromTraceMark(traceMark);
        if (toReturn == null && (structured = this.extractor.getStructuredRequirement(traceMark)) != null) {
            toReturn = this.getRequirementFromTraceMark((String)structured.getFirst());
        }
        return toReturn;
    }
}

