/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public class SubsystemRequirementVerificationLevel
extends AbstractBlam {
    private BranchId branch;
    private Collection<Artifact> subsystemRequirements;
    private StringBuilder report;
    private SkynetTransaction transaction;
    private final String[] columnHeaders = new String[]{"Requirement", "Subsystem", CoreAttributeTypes.ParagraphNumber.getName(), "Current Verification Level", "Changed"};
    private Collection<Artifact> bulkRequirements;

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE);
    }

    public String getName() {
        return "Set Verification Level for Subsystem Requirements";
    }

    private void loadFields(VariableMap variableMap) {
        this.branch = variableMap.getBranch("Branch");
        this.subsystemRequirements = ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.SubsystemRequirementMsWord, (BranchId)this.branch);
        this.bulkRequirements = RelationManager.getRelatedArtifacts(this.subsystemRequirements, (int)1, (RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.RequirementTrace_LowerLevelRequirement});
        this.report = new StringBuilder(AHTML.beginMultiColumnTable((int)100, (int)1));
        this.transaction = TransactionManager.createTransaction((BranchId)this.branch, (String)"Set Verification Level for Subsystem Requirements");
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        this.loadFields(variableMap);
        this.beginReport();
        for (Artifact req : this.subsystemRequirements) {
            this.processSubsystemRequirement(req);
        }
        this.report();
        this.transaction.execute();
    }

    private void report() {
        this.report.append(AHTML.endMultiColumnTable());
        XResultData rd = new XResultData();
        rd.addRaw(this.report.toString());
        XResultDataUI.report((XResultData)rd, (String)"Set Verification Level", (Manipulations[])new Manipulations[]{Manipulations.RAW_HTML});
    }

    private void beginReport() {
        this.report.append(AHTML.addHeaderRowMultiColumnTable((String[])this.columnHeaders));
    }

    private void addReportRow(String ... cells) {
        this.report.append(AHTML.addRowMultiColumnTable((String[])cells));
    }

    private void processSubsystemRequirement(Artifact reqArt) {
        SubsystemRequirement req = new SubsystemRequirement(reqArt);
        req.process();
    }

    private class SubsystemRequirement {
        private final Artifact req;
        private int hardwareComponents;
        private int softwareRequirements;
        private String verificationLevel;
        private String paragraphNumber;
        private String subsystem;

        public SubsystemRequirement(Artifact req) {
            this.req = req;
        }

        public void process() {
            this.getData();
            if (this.meetsCriteria()) {
                if (this.isUnspecified()) {
                    this.adjustVerificationLevel();
                }
                this.report();
            }
        }

        private void getData() {
            this.hardwareComponents = this.getHardwareComponentCount();
            this.softwareRequirements = this.getSoftwareRequirementCount();
            this.paragraphNumber = (String)this.req.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"UNDEFINED");
            this.subsystem = (String)this.req.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)"UNDEFINED");
            this.verificationLevel = (String)this.req.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.VerificationLevel, (Object)"UNDEFINED");
        }

        private int getHardwareComponentCount() {
            return RelationManager.getRelatedArtifactsCount((Artifact)this.req, (RelationTypeSide)CoreRelationTypes.Allocation_Component);
        }

        private int getSoftwareRequirementCount() {
            List traceCollection = RelationManager.getRelatedArtifacts((Artifact)this.req, (RelationTypeSide)CoreRelationTypes.RequirementTrace_LowerLevelRequirement);
            int ret = 0;
            for (Artifact trace : traceCollection) {
                if (!trace.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSoftwareRequirement})) continue;
                ++ret;
            }
            return ret;
        }

        private boolean meetsCriteria() {
            return this.hardwareComponents == 1 && this.softwareRequirements == 0;
        }

        private void adjustVerificationLevel() {
            this.req.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.VerificationLevel, (Object)"Component");
            this.req.persist(SubsystemRequirementVerificationLevel.this.transaction);
        }

        public void report() {
            SubsystemRequirementVerificationLevel.this.addReportRow(new String[]{this.req.getName(), this.subsystem, this.paragraphNumber, this.verificationLevel, String.valueOf(this.isUnspecified())});
        }

        private boolean isUnspecified() {
            return this.verificationLevel.equals("Unspecified");
        }
    }
}

