/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.model.type.LinkType;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;
import org.eclipse.osee.framework.skynet.core.linking.WordMlLinkHandler;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;

public class FixEmbeddedLinksBlam
extends AbstractBlam {
    private static final String BRANCH = "Branch Input";

    public String getXWidgetsXml() {
        return String.format("<xWidgets><XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"%s\"/></xWidgets>", BRANCH);
    }

    public String getDescriptionUsage() {
        return "For a given branch, locate all WholeWordContent attributes and replace branchUuids with that of the selected branch";
    }

    public String getName() {
        return "Fix Embedded Links";
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        BranchId branch = variableMap.getBranch(BRANCH);
        QueryBuilderArtifact queryBuilder = ArtifactQuery.createQueryBuilder((BranchId)branch);
        queryBuilder.andExists(new AttributeTypeId[]{CoreAttributeTypes.WholeWordContent});
        SkynetTransaction tx = TransactionManager.createTransaction((BranchId)branch, (String)"Update embedded links");
        LinkType linkType = LinkType.OSEE_SERVER_LINK;
        for (Artifact artifact : queryBuilder.getResults()) {
            String content;
            if (!artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.WholeWordContent) || !Strings.isValid((String)(content = artifact.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.WholeWordContent, "")))) continue;
            HashSet unknownGuids = new HashSet();
            content = WordMlLinkHandler.link((LinkType)linkType, (Artifact)artifact, (String)content, unknownGuids);
            artifact.setSoleAttributeFromString((AttributeTypeId)CoreAttributeTypes.WholeWordContent, content);
            artifact.persist(tx);
            if (unknownGuids.isEmpty()) continue;
            this.log(new String[]{String.format("Unknown guids found in [%s] - %s", artifact, Collections.toString((String)", ", unknownGuids))});
        }
        tx.execute();
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.TOP_ADMIN, XNavItemCat.OSEE_ADMIN);
    }
}

