/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.api.DefineBranchEndpointApi;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.internal.ServiceUtil;

public class DuplicateParentBlam
extends AbstractBlam {
    BranchId branch = null;

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Branch\" /></xWidgets>";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE_HEALTH);
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        this.branch = variableMap.getBranch("Branch");
        if (this.branch == null || this.branch.isInvalid()) {
            this.log(new String[]{"Must select valid branch."});
            return;
        }
        OseeClient oseeClient = ServiceUtil.getOseeClient();
        DefineBranchEndpointApi defineBrchEp = oseeClient.getDefineBranchEndpoint();
        XResultData results = defineBrchEp.getChildrenWithMultipleParents(this.branch, ArtifactTypeToken.SENTINEL);
        if (results.isErrors()) {
            ArrayList<ArtifactId> artifactIds = new ArrayList<ArtifactId>(results.getIds().size());
            for (String id : results.getIds()) {
                artifactIds.add(ArtifactId.valueOf((String)id));
            }
            this.logf((String)results.getResults().iterator().next(), new Object[0]);
            List artifacts = ArtifactQuery.getArtifactListFrom(artifactIds, (BranchId)this.branch);
            MassArtifactEditor.editArtifacts((String)this.getName(), (Collection)artifacts, (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[0]);
        } else {
            this.log(new String[]{"No artifacts found with duplicate parents."});
        }
    }
}

