/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.views;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osee.framework.core.data.HelpContext;
import org.eclipse.osee.framework.help.ui.OseeHelpContext;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.util.HelpUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericViewPart;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.ote.ui.define.OteDefineImage;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.viewers.IDataChangedListener;
import org.eclipse.osee.ote.ui.define.viewers.TestRunXViewer;
import org.eclipse.osee.ote.ui.define.viewers.data.ArtifactItem;
import org.eclipse.osee.ote.ui.define.viewers.data.BranchItem;
import org.eclipse.osee.ote.ui.define.viewers.data.ScriptItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class TestRunView
extends GenericViewPart
implements IDataChangedListener {
    public static final String VIEW_ID = TestRunView.class.getName();
    private static final String BEGIN_MESSAGE = "To begin, drag and drop a test run artifact from artifact explorer or from an artifact search result window. Alternatively, you can drag and drop a test outfile onto this view.";
    private Action expandAction;
    private Action collapseAction;
    private Action refreshAction;
    private static TestRunXViewer viewer = null;
    private IHandlerService handlerService;
    private ShowOnlyLatestRuns latestRunFilter;
    private boolean isFilterOn;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        PlatformUI.getWorkbench().getService(IHandlerService.class);
        this.handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        viewer = new TestRunXViewer(parent);
        Tree tree = viewer.getTree();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 350;
        tree.setLayoutData((Object)gridData);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setFont(parent.getFont());
        parent.layout();
        this.createActions();
        this.createMenus();
        this.createToolbar();
        this.latestRunFilter = new ShowOnlyLatestRuns();
        this.isFilterOn = false;
        viewer.registerListener(this);
        viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                Object object;
                if (event.stateMask == 262144 && (event.keyCode == 65 || event.keyCode == 97) && (object = event.getSource()) instanceof Tree) {
                    Tree tree = (Tree)object;
                    tree.selectAll();
                }
            }
        });
        this.onDataChanged();
        HelpUtil.setHelp((Control)parent, (HelpContext)OseeHelpContext.TEST_RUN_VIEW);
        HelpUtil.setHelp((Control)viewer.getTree(), (HelpContext)OseeHelpContext.TEST_RUN_VIEW);
        this.setFocusWidget(viewer.getControl());
    }

    protected void createActions() {
        this.expandAction = new Action("Expand All"){

            public void run() {
                viewer.getTree().setRedraw(false);
                viewer.expandAll();
                viewer.getTree().setRedraw(true);
            }
        };
        this.expandAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.EXPAND_STATE));
        this.expandAction.setToolTipText("Expand All");
        this.collapseAction = new Action("Collapse All"){

            public void run() {
                viewer.getTree().setRedraw(false);
                viewer.collapseAll();
                viewer.getTree().setRedraw(true);
            }
        };
        this.collapseAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.COLLAPSE_STATE));
        this.collapseAction.setToolTipText("Collapse All");
        this.refreshAction = new Action("Refresh"){

            public void run() {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        viewer.refresh();
                    }
                });
            }
        };
        this.refreshAction.setToolTipText("Refresh Table");
        this.refreshAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)PluginUiImage.REFRESH));
    }

    private void createMenus() {
        MenuManager menuManager = new MenuManager();
        this.getSite().registerContextMenu(VIEW_ID, menuManager, (ISelectionProvider)viewer);
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.setParent((IContributionManager)this.getViewSite().getActionBars().getMenuManager());
        this.fillMenu((IMenuManager)menuManager);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
    }

    private void fillMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.refreshAction);
        toolbarManager.add((IAction)this.expandAction);
        toolbarManager.add((IAction)this.collapseAction);
    }

    public void setDescription(final String message) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TestRunView.this.setContentDescription(message);
            }
        });
    }

    @Override
    public void onDataChanged() {
        String message = BEGIN_MESSAGE;
        Object object = viewer.getInput();
        if (object != null && object instanceof Collection && !((Collection)object).isEmpty()) {
            message = "";
        }
        this.setDescription(message);
    }

    public static StructuredViewer getViewer() {
        return viewer;
    }

    public void presentGroupedByBranch() {
        BranchItem.setGroupModeEnabled(true);
        viewer.refresh();
    }

    public void presentGroupedByScript() {
        BranchItem.setGroupModeEnabled(false);
        viewer.refresh();
    }

    public void presentWithShortNames() {
        ScriptItem.setFullDescriptionModeEnabled(false);
        ArtifactItem.setFullDescriptionModeEnabled(false);
        viewer.refresh();
    }

    public void presentWithLongNames() {
        ScriptItem.setFullDescriptionModeEnabled(true);
        ArtifactItem.setFullDescriptionModeEnabled(true);
        viewer.refresh();
    }

    public void toggleFilter() {
        this.latestRunFilter.clear();
        if (!this.isFilterOn) {
            this.isFilterOn = true;
            viewer.addFilter(this.latestRunFilter);
        } else {
            this.isFilterOn = false;
            viewer.removeFilter(this.latestRunFilter);
        }
        viewer.refresh();
    }

    private final class ShowOnlyLatestRuns
    extends ViewerFilter {
        private final Map<String, ArtifactItem> latestMap = new HashMap<String, ArtifactItem>();

        private ShowOnlyLatestRuns() {
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            return super.filter(viewer, parent, elements);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean toReturn = false;
            if (element instanceof ArtifactItem) {
                ArtifactItem item1 = (ArtifactItem)element;
                String name = item1.getOperator().getDescriptiveName();
                ArtifactItem item2 = this.latestMap.get(name);
                if (item2 == null) {
                    this.latestMap.put(name, item1);
                    toReturn = true;
                } else {
                    try {
                        Date date1 = item1.getOperator().getEndDate();
                        Date date2 = item2.getOperator().getEndDate();
                        if (date1.after(date2) || date1.equals(date2)) {
                            this.latestMap.put(name, item1);
                            toReturn = true;
                        }
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"Error comparing run dates.", (Throwable)ex);
                    }
                }
            } else {
                toReturn = true;
            }
            return toReturn;
        }

        public void clear() {
            this.latestMap.clear();
        }
    }
}

