/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.viewers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.OteArtifactTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactData;
import org.eclipse.osee.framework.ui.skynet.artifact.ArtifactTransfer;
import org.eclipse.osee.ote.define.jobs.OutfileToArtifactJob;
import org.eclipse.osee.ote.define.utilities.OutfileParserExtensionManager;
import org.eclipse.osee.ote.ui.define.dialogs.BranchComboDialog;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.jobs.AddArtifactsToViewerJob;
import org.eclipse.osee.ote.ui.define.jobs.ReportErrorsJob;
import org.eclipse.osee.ote.ui.define.viewers.XViewerDataManager;
import org.eclipse.osee.ote.ui.define.views.TestRunView;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;

public class DragDropHandler {
    private final XViewerDataManager viewerDataManager;

    public DragDropHandler(XViewerDataManager viewerDataManager) {
        this.viewerDataManager = viewerDataManager;
        this.setupDropSupport();
        this.setupDragSupport();
    }

    private void setupDropSupport() {
        DropTarget dropTarget = new DropTarget(this.viewerDataManager.getControl(), 1);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer(), ArtifactTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                try {
                    DragDropHandler.this.performDrop(event);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 1;
            }
        });
    }

    private void setupDragSupport() {
        DragSource dragSource = new DragSource(this.viewerDataManager.getControl(), 1);
        dragSource.setTransfer(new Transfer[]{ArtifactTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                List<Artifact> artifacts = DragDropHandler.this.viewerDataManager.getSelectedArtifacts();
                if (artifacts.size() > 0) {
                    event.data = new ArtifactData(artifacts.toArray(new Artifact[artifacts.size()]), "", TestRunView.VIEW_ID);
                }
            }

            public void dragStart(DragSourceEvent event) {
                event.doit = false;
                List<Artifact> artifacts = DragDropHandler.this.viewerDataManager.getSelectedArtifacts();
                if (artifacts.size() > 0) {
                    event.doit = true;
                }
            }
        });
    }

    private void performDrop(DropTargetEvent e) {
        StructuredSelection selection;
        Object object = e.data;
        if (object instanceof ArtifactData) {
            this.handleArtifactDrops((ArtifactData)object);
        } else if (object instanceof TreeSelection && (selection = (StructuredSelection)object).size() > 0) {
            URI[] iFiles = this.toResourceArray(selection.toArray());
            if (iFiles.length > 0) {
                try {
                    this.handleResourceDrops(iFiles);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            } else {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"No valid files dropped");
            }
        }
    }

    private URI[] toResourceArray(Object[] objects) {
        ArrayList<URI> toReturn = new ArrayList<URI>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource;
            Object resource;
            Object object = objectArray[n2];
            if (object instanceof IAdaptable && (resource = ((IAdaptable)object).getAdapter(IResource.class)) != null && this.isResourceAllowed(iResource = (IResource)resource)) {
                toReturn.add(iResource.getLocationURI());
            }
            ++n2;
        }
        return toReturn.toArray(new URI[toReturn.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isResourceAllowed(IResource resource) {
        if (resource.getType() != 1) return false;
        if (!resource.isAccessible()) return false;
        String toCheck = resource.getFileExtension();
        try {
            String[] stringArray = OutfileParserExtensionManager.getInstance().getSupportedExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String extension = stringArray[n2];
                if (toCheck.equalsIgnoreCase(extension)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (OseeCoreException oseeCoreException) {}
        return false;
    }

    private void handleArtifactDrops(ArtifactData artifactData) {
        Artifact[] artifactsDropped = artifactData.getArtifacts();
        HashSet<Artifact> artifactsToAdd = new HashSet<Artifact>();
        Artifact[] artifactArray = artifactsDropped;
        int n = artifactsDropped.length;
        int n2 = 0;
        while (n2 < n) {
            Artifact artifact = artifactArray[n2];
            if (artifact.isOfType(new ArtifactTypeId[]{OteArtifactTypes.TestRun})) {
                artifactsToAdd.add(artifact);
            }
            ++n2;
        }
        this.addArtifactsToTable(new ArrayList<Artifact>(artifactsToAdd));
    }

    private void handleResourceDrops(URI[] iFiles) {
        BranchToken branch = BranchComboDialog.getBranchFromUser();
        if (branch.isValid()) {
            OutfileToArtifactJob artifactJob = new OutfileToArtifactJob(branch, iFiles);
            artifactJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IStatus status = event.getResult();
                    if (status.equals(Status.OK_STATUS)) {
                        OutfileToArtifactJob job = (OutfileToArtifactJob)event.getJob();
                        Artifact[] results = job.getResults();
                        URI[] unparseable = job.getUnparseableFiles();
                        DragDropHandler.this.reportUnparseableItems(unparseable);
                        DragDropHandler.this.addArtifactsToTable(Arrays.asList(results));
                    }
                }
            });
            artifactJob.schedule();
        }
    }

    private void addArtifactsToTable(List<Artifact> artifacts) {
        AddArtifactsToViewerJob job = new AddArtifactsToViewerJob(this.viewerDataManager, artifacts);
        job.schedule();
    }

    private void reportUnparseableItems(URI[] unparseable) {
        if (unparseable.length > 0) {
            String title = "Artifact Drop Error";
            String message = "The following file(s) had errors during the parsing operation: ";
            ReportErrorsJob.openError(title, message, unparseable);
        }
    }
}

