/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.dialogs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.osee.ote.define.jobs.RemoteResourceRequestJob;
import org.eclipse.osee.ote.ui.define.OteDefineImage;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.panels.ListSelectionPanel;
import org.eclipse.osee.ote.ui.define.panels.PreviewPanel;
import org.eclipse.osee.ote.ui.define.reports.ExtensionDefinedReports;
import org.eclipse.osee.ote.ui.define.reports.HttpReportRequest;
import org.eclipse.osee.ote.ui.define.reports.ITestRunReport;
import org.eclipse.osee.ote.ui.define.reports.output.OutputFactory;
import org.eclipse.osee.ote.ui.define.reports.output.OutputFormat;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReportsDialog
extends TitleAreaDialog {
    private static final Image MESSAGE_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.COMMIT_WIZ);
    private static final Image TITLE_BAR_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.COMMIT);
    private static final String MESSAGE_TITLE = "Select a report";
    private static final String TITLE_BAR_TEXT = "OSEE Test Run Reports";
    private static final String MESSAGE = "The preview window displays an example of the selected report.";
    private static final String REPORT_SELECTION_TITLE = "Select a Report";
    private static final String PREVIEW_TITLE = "Preview";
    private static final String FORMAT_TITLE = "Select a Format";
    private static final String REPORT_DESCRIPTION = "Report Description";
    private static final String PREVIEW_DESCRIPTION = "Enter Preview Size";
    private static final String REPORT_STORE_ID = String.valueOf(ReportsDialog.class.getName()) + ".reportId";
    private static final String FORMAT_STORE_ID = String.valueOf(ReportsDialog.class.getName()) + ".formatId";
    private static final String PREVIEW_SIZE_STORE_ID = String.valueOf(ReportsDialog.class.getName()) + ".previewSize";
    private static final int DEFAULT_PREVIEW_SIZE = 5;
    private PreviewPanel previewPanel;
    private ListSelectionPanel listSelectionPanel;
    private SelectionChangedListener selectionChangedListener;
    private Text descriptionArea;
    private Text previewSizeArea;
    private String selectedReportId;
    private OutputFormat selectedReportFormat;
    private final List<IFile> filesToDelete = new ArrayList<IFile>();
    private Map<OutputFormat, Button> formatButtons;

    public ReportsDialog(Shell parent) {
        super(parent);
        this.setShellStyle(1264);
    }

    protected Control createButtonBar(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 1024, true, false));
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(content, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        SashForm sash = new SashForm(composite, 256);
        sash.setLayout((Layout)new GridLayout());
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        sash.setFont(parent.getFont());
        this.createReportSelectionArea((Composite)sash);
        Composite panel = new Composite((Composite)sash, 0);
        GridLayout gL1 = new GridLayout();
        gL1.marginHeight = 0;
        gL1.marginWidth = 0;
        panel.setLayout((Layout)gL1);
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFormatAndDescriptionArea(panel);
        this.createPreviewArea(panel);
        sash.setWeights(new int[]{1, 2});
        this.setTitle(MESSAGE_TITLE);
        this.setTitleImage(MESSAGE_IMAGE);
        this.setMessage(MESSAGE);
        this.getShell().setText(TITLE_BAR_TEXT);
        this.getShell().setImage(TITLE_BAR_IMAGE);
        this.attachListeners();
        this.restoreDialog();
        return sash;
    }

    private void restoreDialog() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings();
        if (settings != null) {
            String reportSelected = settings.get(REPORT_STORE_ID);
            String format = settings.get(FORMAT_STORE_ID);
            int value = 0;
            try {
                value = settings.getInt(PREVIEW_SIZE_STORE_ID);
            }
            catch (Exception exception) {
                value = 5;
            }
            this.clamp(this.previewSizeArea, value);
            OutputFormat outputFormat = OutputFormat.HTML;
            int index = 0;
            if (Strings.isValid((String)reportSelected) && Strings.isValid((String)format)) {
                Pair<String, String> pair = ExtensionDefinedReports.getInstance().getIdAndName(reportSelected);
                index = this.listSelectionPanel.indexOf(pair);
                outputFormat = OutputFormat.fromString(format);
            }
            if (index > -1) {
                this.listSelectionPanel.setSelection(index);
            }
            this.setReportFormat(outputFormat);
            for (OutputFormat key : this.formatButtons.keySet()) {
                Button button = this.formatButtons.get((Object)key);
                button.setSelection(key.equals((Object)outputFormat));
            }
        }
    }

    private void saveDialog() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings();
        if (settings != null) {
            String reportSelected = this.getReportSelected();
            String format = this.getReportFormat();
            int previewSize = this.getPreviewSize();
            settings.put(REPORT_STORE_ID, reportSelected);
            settings.put(FORMAT_STORE_ID, format);
            settings.put(PREVIEW_SIZE_STORE_ID, previewSize);
        }
    }

    protected void okPressed() {
        this.saveDialog();
        this.cleanUp(this.filesToDelete);
        super.okPressed();
    }

    private void createReportSelectionArea(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        composite.setText(REPORT_SELECTION_TITLE);
        this.listSelectionPanel = new ListSelectionPanel((Composite)composite, 0, 300, 300, (IBaseLabelProvider)new ListLabelProvider());
        this.listSelectionPanel.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                Pair pair1 = (Pair)o1;
                Pair pair2 = (Pair)o2;
                return this.getComparator().compare(pair1.getSecond(), pair2.getSecond());
            }
        });
        Pair<String, String>[] reportNames = ExtensionDefinedReports.getInstance().getIdsAndNames();
        this.listSelectionPanel.setInput(reportNames);
        this.listSelectionPanel.setSelection(0);
    }

    private void createFormatAndDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gL = new GridLayout(2, false);
        gL.marginHeight = 0;
        gL.marginWidth = 0;
        composite.setLayout((Layout)gL);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createFormatArea(composite);
        Composite panel = new Composite(composite, 0);
        GridLayout gL1 = new GridLayout();
        gL1.marginHeight = 0;
        gL1.marginWidth = 0;
        panel.setLayout((Layout)gL1);
        panel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createDescriptionArea(panel);
        this.createPreviewSizeArea(panel);
    }

    private void createPreviewSizeArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setFont(parent.getFont());
        group.setText(PREVIEW_DESCRIPTION);
        this.previewSizeArea = new Text((Composite)group, 2052);
        this.previewSizeArea.setTextLimit(2);
        GridData gd = new GridData(131072, 4, false, false);
        gd.heightHint = this.convertHeightInCharsToPixels(1);
        gd.widthHint = this.convertWidthInCharsToPixels(4);
        this.previewSizeArea.setLayoutData((Object)gd);
        new Widgets.IntegerTextEntryHandler(this.previewSizeArea, false, 2){

            public void applyValue(long value) {
                ReportsDialog.this.clamp(ReportsDialog.this.previewSizeArea, value);
            }
        };
        Label label = new Label((Composite)group, 0);
        label.setText("[ 0-10 ]");
        label.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void clamp(Text text, long value) {
        if (value < 0L) {
            this.previewSizeArea.setText(Integer.toString(0));
        }
        if (value > 10L) {
            this.previewSizeArea.setText(Integer.toString(10));
        }
    }

    private void createDescriptionArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setFont(parent.getFont());
        group.setText(REPORT_DESCRIPTION);
        this.descriptionArea = new Text((Composite)group, 66);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = 100;
        gd.widthHint = 100;
        this.descriptionArea.setLayoutData((Object)gd);
        this.descriptionArea.setEditable(false);
    }

    private void createFormatArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        group.setFont(parent.getFont());
        group.setText(FORMAT_TITLE);
        this.formatButtons = new HashMap<OutputFormat, Button>();
        OutputFormat[] outputFormatArray = OutputFormat.values();
        int n = outputFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutputFormat format = outputFormatArray[n2];
            Button button = new Button((Composite)group, 16);
            button.setText(format.name());
            button.setData((Object)format);
            if (format.equals((Object)OutputFormat.HTML)) {
                button.setSelection(true);
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    if (button.getSelection()) {
                        ReportsDialog.this.setReportFormat((OutputFormat)((Object)button.getData()));
                    }
                }
            });
            this.formatButtons.put(format, button);
            ++n2;
        }
    }

    private void createPreviewArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setFont(parent.getFont());
        group.setText(PREVIEW_TITLE);
        this.previewPanel = new PreviewPanel((Composite)group, 0);
    }

    private void attachListeners() {
        this.listSelectionPanel.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Pair item;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (item = (Pair)selection.getFirstElement()) != null) {
                    ReportsDialog.this.selectedReportId = (String)item.getFirst();
                }
                ReportsDialog.this.okPressed();
            }
        });
        this.selectionChangedListener = new SelectionChangedListener();
        this.listSelectionPanel.addSelectionChangedListener(this.selectionChangedListener);
    }

    public String getReportSelected() {
        return this.selectedReportId;
    }

    public String getReportFormat() {
        return this.selectedReportFormat.name();
    }

    private void setReportFormat(OutputFormat reportFormat) {
        this.selectedReportFormat = reportFormat;
        this.selectionChangedListener.selectionChanged(null);
    }

    private PreviewPanel.PanelEnum asPanelEnum(OutputFormat format) {
        PreviewPanel.PanelEnum toReturn = PreviewPanel.PanelEnum.DEFAULT;
        switch (format) {
            case HTML: 
            case PDF: 
            case RTF: 
            case EXCEL: {
                toReturn = PreviewPanel.PanelEnum.BROWSER;
                break;
            }
            default: {
                toReturn = PreviewPanel.PanelEnum.DEFAULT;
            }
        }
        return toReturn;
    }

    private void updatePanel(final PreviewPanel.PanelEnum panelId, final URI uri, final String description, List<IFile> oldIFiles) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ReportsDialog.this.previewPanel.updatePreview(panelId, uri);
                ReportsDialog.this.previewPanel.setDisplay(panelId);
                ReportsDialog.this.descriptionArea.setText(description);
            }
        });
        this.cleanUp(oldIFiles);
    }

    private int getPreviewSize() {
        int toReturn = 5;
        String value = this.previewSizeArea.getText();
        try {
            toReturn = Integer.parseInt(value);
        }
        catch (Exception exception) {
            toReturn = 5;
            this.updatePreviewSizeValue(toReturn);
        }
        return toReturn;
    }

    private void updatePreviewSizeValue(final int value) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ReportsDialog.this.previewSizeArea.setText(Integer.toString(value));
            }
        });
    }

    private void generatePreview(OutputFormat outputFormat, String reportId, ITestRunReport report) throws URISyntaxException {
        String urlRequest = HttpReportRequest.getUrl(reportId, outputFormat.name(), "local", this.getPreviewSize());
        String fileName = OutputFactory.getOutputFilename(outputFormat, reportId);
        switch (outputFormat) {
            case HTML: {
                this.updatePanel(this.asPanelEnum(outputFormat), new URI(urlRequest), report.getDescription(), this.filesToDelete);
                break;
            }
            default: {
                this.remoteFileToLocal(outputFormat, urlRequest, fileName, report);
            }
        }
    }

    private void remoteFileToLocal(OutputFormat outputFormat, String urlRequest, String fileName, ITestRunReport report) {
        RemoteResourceRequestJob requestJob = new RemoteResourceRequestJob(urlRequest, fileName);
        requestJob.addJobChangeListener((IJobChangeListener)new PreviewUpdateJobChangeListener(report, outputFormat));
        requestJob.getDownloadedFile();
        requestJob.schedule();
    }

    private void cleanUp(final List<IFile> iFiles) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (IFile iFile : iFiles) {
                    if (iFile == null || !iFile.exists()) continue;
                    try {
                        iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        ReportsDialog.this.filesToDelete.remove(iFile);
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
    }

    private final class ListLabelProvider
    extends LabelProvider {
        private ListLabelProvider() {
        }

        public Image getImage(Object element) {
            Image toReturn = null;
            if (element instanceof Pair) {
                toReturn = ExtensionDefinedReports.getInstance().getImage((String)((Pair)element).getFirst());
            }
            return toReturn;
        }

        public String getText(Object element) {
            if (element instanceof Pair) {
                return (String)((Pair)element).getSecond();
            }
            return super.getText(element);
        }
    }

    private final class PreviewUpdateJobChangeListener
    extends JobChangeAdapter {
        private final ITestRunReport report;
        private final OutputFormat format;

        private PreviewUpdateJobChangeListener(ITestRunReport report, OutputFormat format) {
            this.report = report;
            this.format = format;
        }

        public void done(IJobChangeEvent event) {
            IFile iFile;
            IStatus status = event.getResult();
            if ((status.equals(Status.OK_STATUS) || status.getCode() == 0) && (iFile = ((RemoteResourceRequestJob)event.getJob()).getDownloadedFile()) != null) {
                ReportsDialog.this.updatePanel(ReportsDialog.this.asPanelEnum(this.format), iFile.getLocationURI(), this.report.getDescription(), ReportsDialog.this.filesToDelete);
                ReportsDialog.this.filesToDelete.add(iFile);
            }
        }
    }

    private final class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ITestRunReport report;
            Pair item;
            IStructuredSelection selection = ReportsDialog.this.listSelectionPanel.getSelection();
            if (selection != null && (item = (Pair)selection.getFirstElement()) != null && (report = ExtensionDefinedReports.getInstance().getReportGenerator((String)item.getFirst())) != null) {
                ReportsDialog.this.selectedReportId = (String)item.getFirst();
                try {
                    ReportsDialog.this.generatePreview(ReportsDialog.this.selectedReportFormat, ReportsDialog.this.selectedReportId, report);
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
    }
}

