/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.internal.fields;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.osee.framework.core.model.OseeEnumEntry;
import org.eclipse.osee.framework.core.model.internal.fields.CollectionField;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class EnumEntryField
extends CollectionField<OseeEnumEntry> {
    public EnumEntryField(Collection<OseeEnumEntry> enumEntries) {
        super(enumEntries);
    }

    @Override
    protected Collection<OseeEnumEntry> checkInput(Collection<OseeEnumEntry> input) {
        this.checkEnumEntryIntegrity(input);
        HashSet<OseeEnumEntry> toReturn = new HashSet<OseeEnumEntry>();
        HashSet<OseeEnumEntry> newEntries = new HashSet<OseeEnumEntry>();
        Object currentEntries = this.get();
        for (OseeEnumEntry entry : input) {
            boolean wasFound = false;
            String nameToCheck = entry.getName();
            int ordinalToCheck = entry.ordinal();
            Iterator iterator = currentEntries.iterator();
            while (iterator.hasNext()) {
                OseeEnumEntry existingEntry = (OseeEnumEntry)iterator.next();
                if (existingEntry.getName().equals(nameToCheck)) {
                    wasFound = true;
                    existingEntry.setName(nameToCheck);
                    existingEntry.setOrdinal(ordinalToCheck);
                }
                if (!wasFound) continue;
                toReturn.add(existingEntry);
                break;
            }
            if (wasFound) continue;
            newEntries.add(entry);
        }
        toReturn.addAll(newEntries);
        return toReturn;
    }

    private void checkEnumEntryIntegrity(Collection<OseeEnumEntry> oseeEnumEntries) {
        HashMap<String, OseeEnumEntry> nameToEnum = new HashMap<String, OseeEnumEntry>();
        HashMap<Integer, OseeEnumEntry> ordinalToEnum = new HashMap<Integer, OseeEnumEntry>();
        for (OseeEnumEntry entry : oseeEnumEntries) {
            Conditions.checkNotNullOrEmpty((String)entry.getName(), (String)"Osee Enum Entry name");
            Conditions.checkExpressionFailOnTrue((entry.ordinal() < 0 ? 1 : 0) != 0, (String)"Osee Enum Entry ordinal must be greater than zero", (Object[])new Object[0]);
            if (nameToEnum.containsKey(entry.getName())) {
                throw new OseeArgumentException("Unique enumEntry name violation - %s already exists.", new Object[]{entry});
            }
            nameToEnum.put(entry.getName(), entry);
            if (ordinalToEnum.containsKey(entry.ordinal())) {
                OseeEnumEntry existingEntry = (OseeEnumEntry)ordinalToEnum.get(entry.ordinal());
                throw new OseeArgumentException("Unique enumEntry ordinal violation - ordinal [%d] is used by existing entry:[%s] and new entry:[%s]", new Object[]{entry.ordinal(), existingEntry, entry});
            }
            ordinalToEnum.put(entry.ordinal(), entry);
        }
    }
}

