/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.review;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewOption;
import org.eclipse.osee.framework.core.util.Result;

public class DecisionReviewOption
implements IAtsDecisionReviewOption {
    private String name;
    private final Collection<String> assignees = new HashSet<String>();
    private final Collection<String> names = new HashSet<String>();
    private boolean followupRequired;

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public DecisionReviewOption(String name) {
        this(name, (AtsUser)null, false);
    }

    public DecisionReviewOption(String name, AtsUser assignee, boolean followup) {
        this(name, assignee == null ? Collections.emptyList() : Collections.singleton(assignee), followup);
    }

    public DecisionReviewOption(String name, boolean followup, Collection<String> userIds) {
        this.name = name;
        this.followupRequired = followup;
        if (userIds != null) {
            this.assignees.addAll(userIds);
        }
    }

    public DecisionReviewOption(String name, Collection<AtsUser> assignees, boolean followup) {
        this.name = name;
        this.followupRequired = followup;
        if (assignees != null) {
            for (AtsUser user : assignees) {
                this.assignees.add(user.getUserId());
            }
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DecisionReviewOption) {
            DecisionReviewOption state = (DecisionReviewOption)obj;
            return state.name.equals(this.name);
        }
        return super.equals(obj);
    }

    public Collection<String> getAssignees() {
        return this.assignees;
    }

    public void setAssignees(Collection<AtsUser> assignees) {
        this.assignees.clear();
        if (assignees != null) {
            for (AtsUser user : assignees) {
                this.assignees.add(user.getUserId());
            }
        }
    }

    public void setAssignee(AtsUser assignee) {
        this.assignees.clear();
        if (assignee != null) {
            this.assignees.add(assignee.getUserId());
        }
    }

    public void addAssignee(AtsUser assignee) {
        if (assignee != null) {
            this.assignees.add(assignee.getUserId());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append(";");
        for (String userId : this.assignees) {
            sb.append("<" + userId + ">");
        }
        sb.append(";");
        sb.append(this.followupRequired);
        return sb.toString();
    }

    public Result setFromXml(String xml) {
        Matcher m = Pattern.compile("^(.*?);(.*?);(.*)$").matcher(xml);
        if (m.find()) {
            String toState = m.group(2).toLowerCase();
            this.name = m.group(1);
            if (this.name.equals("")) {
                return new Result("Invalid name");
            }
            if (toState.equals("followup")) {
                this.followupRequired = true;
            } else if (toState.equals("completed")) {
                this.followupRequired = false;
            } else {
                return new Result("Invalid followup string \"" + m.group(2) + "\"\nShould be followup or completed");
            }
            m = Pattern.compile("<(.*?)>").matcher(m.group(3));
            while (m.find()) {
                this.assignees.add(m.group(1));
            }
            if (this.followupRequired && this.assignees.isEmpty()) {
                return new Result("If followup is specified, must set assignees.\nShould be: <userid><userid>");
            }
            if (!this.followupRequired && this.assignees.size() > 0) {
                return new Result("If completed is specified, don't specify assigness.  Leave blank.\n");
            }
        } else {
            return new Result("Can't unpack decision option data => " + xml + "\n\n" + "must be in format: \"Name;(followup|completed);<userid1><userid2>\"" + "where true if followup is required; false if not.  If followup required, assignees will be userid1, userid2.");
        }
        return Result.TrueResult;
    }

    @Override
    public boolean isFollowupRequired() {
        return this.followupRequired;
    }

    @Override
    public void setFollowupRequired(boolean followupRequired) {
        this.followupRequired = followupRequired;
    }

    @Override
    public Collection<String> getUserIds() {
        return this.assignees;
    }

    @Override
    public void setUserIds(List<String> userIds) {
        this.assignees.clear();
        this.assignees.addAll(userIds);
    }

    @Override
    public Collection<String> getUserNames() {
        return this.names;
    }

    @Override
    public void setUserNames(List<String> userNames) {
        this.names.clear();
        this.names.addAll(userNames);
    }
}

