/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal.dialog;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DateSelectionDialog
extends MessageDialog {
    private Date initialDate;
    private Date selectedDate;
    private final String dialogMessage;

    public DateSelectionDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, Date selectedDate) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.initialDate = selectedDate;
        this.dialogMessage = dialogMessage;
    }

    public DateSelectionDialog(String dialogTitle, String dialogMessage, Date selectedDate) {
        this(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 0, new String[]{XViewerText.get("button.ok"), XViewerText.get("button.cancel")}, 0, selectedDate);
    }

    protected Control createDialogArea(Composite container) {
        Composite filterComp = new Composite(container, 0);
        filterComp.setLayout((Layout)new GridLayout(1, false));
        filterComp.setLayoutData((Object)new GridData(1808));
        new Label(filterComp, 0).setText(this.dialogMessage);
        DateTime dp = new DateTime(filterComp, 1024);
        dp.setLayoutData((Object)new GridData(768));
        if (this.initialDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.initialDate);
            dp.setYear(cal.get(1));
            dp.setMonth(cal.get(2));
            dp.setDay(cal.get(6));
        }
        dp.addListener(13, e -> {
            Calendar cal = Calendar.getInstance();
            cal.set(dp.getYear(), dp.getMonth(), dp.getDay());
            this.selectedDate = cal.getTime();
        });
        Button clearButton = new Button(filterComp, 8);
        clearButton.setText(XViewerText.get("button.clear"));
        clearButton.addListener(13, e -> {
            Date date = this.selectedDate = null;
        });
        return filterComp;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(Date initialDate) {
        this.initialDate = initialDate;
    }

    public boolean isNoneSelected() {
        return this.selectedDate == null;
    }
}

