/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal.dialog;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.DateRangeType;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.DialogWithEntry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColumnFilterDialog
extends DialogWithEntry {
    private final XViewerColumn column;
    private ComboViewer dateRangeTypeCombo;
    private DateTime date1Widget;
    private Date date1;
    private Date date2;
    private DateRangeType dateRangeType = null;
    private DateTime date2Widget;
    private DateTime time1Widget;
    private DateTime time2Widget;
    private Composite widgetComp;

    public ColumnFilterDialog(Shell shell, String dialogTitle, String dialogMessage, int question, String[] strings, int i, XViewerColumn column) {
        super(shell, dialogTitle, null, dialogMessage, 3, strings, 0);
        this.column = column;
    }

    @Override
    protected void createExtendedArea(Composite parent) {
        super.createExtendedArea(parent);
        if (this.column.getSortDataType() == SortDataType.Date) {
            this.widgetComp = new Composite(parent, 0);
            this.widgetComp.setLayout((Layout)new GridLayout(6, false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.widgetComp.setLayoutData((Object)gd);
            Label label = new Label(this.widgetComp, 0);
            label.setText("Date Match: ");
            this.dateRangeTypeCombo = new ComboViewer(this.widgetComp, 0);
            this.dateRangeTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.dateRangeTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((DateRangeType)element).getDisplayName();
                }
            });
            this.dateRangeTypeCombo.setInput((Object)DateRangeType.values());
            this.dateRangeTypeCombo.addSelectionChangedListener(event -> {
                String text2 = this.dateRangeTypeCombo.getCombo().getText();
                this.dateRangeType = DateRangeType.get((String)text2);
                this.updateDate2Composite();
            });
            this.date1Widget = new DateTime(this.widgetComp, 1024);
            this.date1Widget.addListener(13, e -> this.setDate1Selection());
            Calendar cal = Calendar.getInstance();
            cal.set(this.date1Widget.getYear(), this.date1Widget.getMonth(), this.date1Widget.getDay(), 0, 0);
            this.date1 = cal.getTime();
            this.time1Widget = new DateTime(this.widgetComp, 128);
            this.time1Widget.addListener(13, e -> this.setDate1Selection());
            this.time1Widget.setHours(0);
            this.time1Widget.setMinutes(0);
            this.time1Widget.setSeconds(0);
        }
    }

    private boolean isBetweenDates() {
        this.dateRangeType = DateRangeType.get((String)this.dateRangeTypeCombo.getCombo().getText());
        return this.dateRangeType == DateRangeType.Between_Dates;
    }

    public void updateDate2Composite() {
        if (this.isBetweenDates()) {
            this.date2Widget = new DateTime(this.widgetComp, 1024);
            this.date2Widget.addListener(13, e -> this.setDate2Selection());
            this.time2Widget = new DateTime(this.widgetComp, 128);
            this.time2Widget.addListener(13, e -> this.setDate2Selection());
            this.time2Widget.setHours(0);
            this.time2Widget.setMinutes(0);
            this.time2Widget.setSeconds(0);
        } else if (this.date2Widget != null) {
            this.date2Widget.dispose();
            this.date2Widget = null;
            this.time2Widget.dispose();
            this.time2Widget = null;
        }
        this.widgetComp.layout(true, true);
        Point newSize = this.getShell().computeSize(-1, -1, true);
        this.getShell().setSize(newSize);
    }

    private void setDate1Selection() {
        Calendar cal = Calendar.getInstance();
        cal.set(this.date1Widget.getYear(), this.date1Widget.getMonth(), this.date1Widget.getDay(), this.time1Widget.getHours(), this.time1Widget.getMinutes());
        this.date1 = cal.getTime();
    }

    private void setDate2Selection() {
        if (this.date2Widget.isEnabled()) {
            Calendar cal = Calendar.getInstance();
            cal.set(this.date2Widget.getYear(), this.date2Widget.getMonth(), this.date2Widget.getDay(), this.date2Widget.getHours(), this.date2Widget.getMinutes());
            this.date2 = cal.getTime();
        } else {
            this.date2 = null;
        }
    }

    public Date getDate1() {
        return this.date1;
    }

    public void setDate1(Date date1) {
        this.date1 = date1;
    }

    public Date getDate2() {
        return this.date2;
    }

    public void setDate2(Date date2) {
        this.date2 = date2;
    }

    public DateRangeType getDateRangeType() {
        return this.dateRangeType;
    }

    public void setDateRangeType(DateRangeType dateRangeType) {
        this.dateRangeType = dateRangeType;
    }
}

