/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.internal.FrameworkUiImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class DynamicWizard
implements IWizard {
    public static final String DEFAULT_IMAGE = "org.eclipse.jface.wizard.Wizard.pageImage";
    private IWizardContainer container = null;
    private final Map<String, IWizardPage> pages = new HashMap<String, IWizardPage>();
    private boolean needsProgressMonitor = false;
    private boolean forcePreviousAndNextButtons = false;
    private boolean isHelpAvailable = false;
    private Image defaultImage = null;
    private ImageDescriptor defaultImageDescriptor = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.jface.wizard.Wizard.pageImage");
    private RGB titleBarColor = null;
    private String windowTitle = null;
    private IDialogSettings dialogSettings = null;
    private IWizardPage startingPage = null;

    static {
        JFaceResources.getImageRegistry().put(DEFAULT_IMAGE, ImageManager.getImage(FrameworkUiImage.PAGE));
    }

    protected DynamicWizard() {
    }

    public void addPage(IWizardPage page) {
        if (!this.pages.containsKey(page.getName())) {
            this.pages.put(page.getName(), page);
            page.setWizard((IWizard)this);
        }
    }

    public void addPages() {
    }

    public boolean canFinish() {
        Set<String> keys = this.pages.keySet();
        for (String key : keys) {
            if (this.pages.get(key).isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        Set<String> keys = this.pages.keySet();
        for (String key : keys) {
            IWizardPage page = this.pages.get(key);
            page.createControl(pageContainer);
            Assert.isNotNull((Object)page.getControl());
        }
    }

    public void dispose() {
        Set<String> keys = this.pages.keySet();
        for (String key : keys) {
            this.pages.get(key).dispose();
        }
        if (this.defaultImage != null) {
            JFaceResources.getResources().destroyImage(this.defaultImageDescriptor);
            this.defaultImage = null;
        }
    }

    public IWizardContainer getContainer() {
        return this.container;
    }

    public Image getDefaultPageImage() {
        if (this.defaultImage == null) {
            this.defaultImage = JFaceResources.getResources().createImageWithDefault(this.defaultImageDescriptor);
        }
        return this.defaultImage;
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    public IWizardPage getPage(String name) {
        return this.pages.get(name);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return page.getNextPage();
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public IWizardPage[] getPages() {
        Collection<IWizardPage> collectionOfPages = this.pages.values();
        return collectionOfPages.toArray(new IWizardPage[collectionOfPages.size()]);
    }

    public boolean containsPage(IWizardPage page) {
        Set<String> pageNames = this.pages.keySet();
        return pageNames.contains(page.getName());
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return page.getPreviousPage();
    }

    public Shell getShell() {
        if (this.container == null) {
            return null;
        }
        return this.container.getShell();
    }

    public IWizardPage getStartingPage() {
        return this.startingPage;
    }

    public RGB getTitleBarColor() {
        return this.titleBarColor;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public boolean isHelpAvailable() {
        return this.isHelpAvailable;
    }

    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    public boolean needsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    public boolean performCancel() {
        return true;
    }

    public abstract boolean performFinish();

    public void setContainer(IWizardContainer wizardContainer) {
        this.container = wizardContainer;
    }

    public void setDefaultPageImageDescriptor(ImageDescriptor imageDescriptor) {
        this.defaultImageDescriptor = imageDescriptor;
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.dialogSettings = settings;
    }

    public void setForcePreviousAndNextButtons(boolean b) {
        this.forcePreviousAndNextButtons = b;
    }

    public void setHelpAvailable(boolean b) {
        this.isHelpAvailable = b;
    }

    public void setNeedsProgressMonitor(boolean b) {
        this.needsProgressMonitor = b;
    }

    public void setTitleBarColor(RGB color) {
        this.titleBarColor = color;
    }

    public void setWindowTitle(String newTitle) {
        this.windowTitle = newTitle;
        if (this.container != null) {
            this.container.updateWindowTitle();
        }
    }

    public void setStartingPage(IWizardPage startingPage) {
        this.startingPage = startingPage;
    }
}

