/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging;

import java.io.Serializable;
import java.net.URI;
import org.eclipse.osee.framework.messaging.Component;

public class NodeInfo
implements Serializable {
    private static final long serialVersionUID = -5245181117185581620L;
    private final URI uri;
    private final String name;
    private final String nameWithColon;

    public NodeInfo(String name, URI uri) {
        this.uri = uri;
        this.name = name;
        this.nameWithColon = String.valueOf(name) + ":";
    }

    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.uri;
    }

    public String getComponentName() {
        return this.name;
    }

    public String getComponentNameForRoutes() {
        return this.nameWithColon;
    }

    public boolean isVMComponent() {
        return this.getComponentName().equals(Component.VM.getComponentName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeInfo other = (NodeInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

