/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarLexer;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarParser;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Xml;

public class WordCoreUtil {
    public static String FEATUREAPP = "feature";
    public static String CONFIGAPP = "configuration";
    public static String CONFIGGRPAPP = "configurationgroup";
    public static String MAX_TAG_OCCURENCE = "30";
    public static String WORD_ML_TAGS = "(\\<[^>]*?>){0," + MAX_TAG_OCCURENCE + "}";
    public static String TABLE_CELL = "<w:tc>";
    public static String TABLE = "<w:tbl>";
    public static String START_TABLE_ROW = "<w:tr wsp:rsidR=";
    public static String END_TABLE_ROW = "</w:tr>";
    public static String LIST = "<w:listPr>";
    public static String START_PARAGRAPH = "<w:p wsp:rsid";
    public static String WHOLE_END_PARAGRAPH = "</w:t></w:r></w:p>";
    public static String END_PARAGRAPH = "</w:p>";
    public static String END = "E" + WORD_ML_TAGS + "n" + WORD_ML_TAGS + "d ?" + WORD_ML_TAGS + " ?";
    public static String ELSE = "E" + WORD_ML_TAGS + "l" + WORD_ML_TAGS + "s" + WORD_ML_TAGS + "e ?";
    public static String FEATURE = "F" + WORD_ML_TAGS + "e" + WORD_ML_TAGS + "a" + WORD_ML_TAGS + "t" + WORD_ML_TAGS + "u" + WORD_ML_TAGS + "r" + WORD_ML_TAGS + "e";
    public static String CONFIG = "C" + WORD_ML_TAGS + "o" + WORD_ML_TAGS + "n" + WORD_ML_TAGS + "f" + WORD_ML_TAGS + "i" + WORD_ML_TAGS + "g" + WORD_ML_TAGS + "u" + WORD_ML_TAGS + "r" + WORD_ML_TAGS + "a" + WORD_ML_TAGS + "t" + WORD_ML_TAGS + "i" + WORD_ML_TAGS + "o" + WORD_ML_TAGS + "n";
    public static String CONFIGGRP = "C" + WORD_ML_TAGS + "o" + WORD_ML_TAGS + "n" + WORD_ML_TAGS + "f" + WORD_ML_TAGS + "i" + WORD_ML_TAGS + "g" + WORD_ML_TAGS + "u" + WORD_ML_TAGS + "r" + WORD_ML_TAGS + "a" + WORD_ML_TAGS + "t" + WORD_ML_TAGS + "i" + WORD_ML_TAGS + "o" + WORD_ML_TAGS + "n" + WORD_ML_TAGS + "G" + WORD_ML_TAGS + "r" + WORD_ML_TAGS + "o" + WORD_ML_TAGS + "u" + WORD_ML_TAGS + "p";
    public static String NOT = "N" + WORD_ML_TAGS + "o" + WORD_ML_TAGS + "t";
    public static String ENDBRACKETS = String.valueOf(WORD_ML_TAGS) + " ?(\\[(.*?)\\]) ?";
    public static String OPTIONAL_ENDBRACKETS = " ?(" + WORD_ML_TAGS + "(\\[.*?\\]))?";
    public static String BEGINFEATURE = String.valueOf(FEATURE) + WORD_ML_TAGS + " ?" + ENDBRACKETS;
    public static String ENDFEATURE = String.valueOf(END) + WORD_ML_TAGS + FEATURE + OPTIONAL_ENDBRACKETS;
    public static String BEGINCONFIG = String.valueOf(CONFIG) + WORD_ML_TAGS + "( " + WORD_ML_TAGS + NOT + WORD_ML_TAGS + ")? ?" + ENDBRACKETS;
    public static String ENDCONFIG = String.valueOf(END) + WORD_ML_TAGS + CONFIG + OPTIONAL_ENDBRACKETS;
    public static String BEGINCONFIGGRP = String.valueOf(CONFIGGRP) + WORD_ML_TAGS + "( " + WORD_ML_TAGS + NOT + WORD_ML_TAGS + ")? ?" + ENDBRACKETS;
    public static String ENDCONFIGGRP = String.valueOf(END) + WORD_ML_TAGS + CONFIGGRP + OPTIONAL_ENDBRACKETS;
    public static String ELSE_EXP = "(" + FEATURE + "|" + CONFIGGRP + "|" + CONFIG + ")" + WORD_ML_TAGS + " " + WORD_ML_TAGS + ELSE;
    public static Pattern ELSE_PATTERN = Pattern.compile(ELSE_EXP, 40);
    public static String BIN_DATA_STRING = "<w:binData.*?w:name=\"(.*?)\".*?</w:binData>";
    public static Pattern BIN_DATA_PATTERN = Pattern.compile(BIN_DATA_STRING, 42);
    public static Pattern IMG_SRC_PATTERN = Pattern.compile("<v:imagedata.*?src=\"([^\"]+)", 34);
    public static Pattern FULL_PATTERN = Pattern.compile("(" + BEGINFEATURE + ")|(" + ENDFEATURE + ")|(" + BEGINCONFIGGRP + ")|(" + ENDCONFIGGRP + ")|(" + BEGINCONFIG + ")|(" + ENDCONFIG + ")", 40);
    public static Pattern LIST_PATTERN = Pattern.compile("<w:listPr>(<w:ilvl([^>]*?)/?>(</w:ilvl>)?)?(<w:ilfo([^>]*?)/?>(</w:ilfo>)?)?<wx:t wx:val=\"([^>]*?)\"/?>(</wx:t>)?<wx:font wx:val=\"[^\"]*?\"/?>(</wx:font>)?</w:listPr>");
    public static String EMPTY_LIST_REGEX = "<w:p wsp:rsidP=\"[^\"]*?\" wsp:rsidR=\"[^\"]*?\" wsp:rsidRDefault=\"[^\"]*?\"><w:pPr><w:pStyle w:val=\"[^\"]*?\"></w:pStyle><w:listPr><wx:t wx:val=\"([^>]*?)\"></wx:t><wx:font wx:val=\"[^\"]*?\"></wx:font></w:listPr></w:pPr><w:r><w:t></w:t></w:r></w:p>";
    public static String OSEE_BOOKMARK_REGEX = "^<aml:annotation[^<>]+w:name=\"OSEE\\.([^\"]*)\"[^<>]+w:type=\"Word\\.Bookmark\\.Start\\\"/><aml:annotation[^<>]+Word.Bookmark.End\\\"/>";
    public static String OSEE_HYPERLINK_REGEX = "<w:instrText>\\s+HYPERLINK[^<>]+\"OSEE\\.([^\"]*)\"\\s+</w:instrText>";
    private static final Pattern tagKiller = Pattern.compile("<.*?>", 42);
    private static final Pattern paragraphPattern = Pattern.compile("<w:p( .*?)?>", 42);
    private static final String AML_ANNOTATION = "<.??aml:annotation.*?>";
    private static final String AML_CONTENT = "<.??aml:content.*?>";
    private static final String DELETIONS = "<w:delText>.*?</w:delText>";
    public static final int beginFeatureMatcherGroup = 1;
    public static final int beginConfigGroupMatcherGroup = 26;
    public static final int beginConfigMatcherGroup = 78;
    public static final int endFeatureMatcherGroup = 12;
    public static final int endConfigGroupMatcherGroup = 53;
    public static final int endConfigMatcherGroup = 100;
    public static final int endFeatureBracketMatcherGroup = 23;
    public static final int endConfigGroupBracketMatcherGroup = 75;
    public static final int endConfigBracketMatcherGroup = 117;

    public static boolean containsWordAnnotations(String wordml) {
        return wordml.contains("<w:delText>") || wordml.contains("w:type=\"Word.Insertion\"") || wordml.contains("w:type=\"Word.Formatting\"") || wordml.contains("w:type=\"Word.Deletion\"");
    }

    public static boolean containsLists(String wordMl) {
        return LIST_PATTERN.matcher(wordMl).find();
    }

    public static String removeAnnotations(String wordml) {
        String response = wordml;
        if (Strings.isValid((String)response)) {
            response = response.replaceAll(AML_ANNOTATION, "");
            response = response.replaceAll(AML_CONTENT, "");
            response = response.replaceAll(DELETIONS, "");
        }
        return response;
    }

    public static boolean areApplicabilityTagsInvalid(String wordml, BranchId branch, HashCollection<String, String> validFeatureValues, Set<String> allValidConfigurations, Set<String> allValidConfigurationGroups) {
        Matcher matcher = FULL_PATTERN.matcher(wordml);
        Stack<ApplicabilityBlock> applicabilityBlocks = new Stack<ApplicabilityBlock>();
        int applicBlockCount = 0;
        while (matcher.find()) {
            String endConfigurationGroup;
            String beginFeature = matcher.group(1) != null ? WordCoreUtil.textOnly(matcher.group(1)) : null;
            String beginConfiguration = matcher.group(78) != null ? WordCoreUtil.textOnly(matcher.group(78)) : null;
            String beginConfigurationGroup = matcher.group(26) != null ? WordCoreUtil.textOnly(matcher.group(26)) : null;
            String endFeature = matcher.group(12) != null ? WordCoreUtil.textOnly(matcher.group(12)) : null;
            String endConfiguration = matcher.group(100) != null ? WordCoreUtil.textOnly(matcher.group(100)) : null;
            String string = endConfigurationGroup = matcher.group(53) != null ? WordCoreUtil.textOnly(matcher.group(53)) : null;
            if (beginFeature != null && beginFeature.toLowerCase().contains(FEATUREAPP)) {
                ++applicBlockCount;
                applicabilityBlocks.add(WordCoreUtil.createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType.Feature, beginFeature));
                continue;
            }
            if (beginConfiguration != null && beginConfiguration.toLowerCase().contains(CONFIGAPP)) {
                if (!WordCoreUtil.isValidConfigurationBracket(beginConfiguration, allValidConfigurations)) continue;
                ++applicBlockCount;
                applicabilityBlocks.add(WordCoreUtil.createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType.Configuration, beginConfiguration));
                continue;
            }
            if (beginConfigurationGroup != null && beginConfigurationGroup.toLowerCase().contains(CONFIGGRPAPP)) {
                if (!WordCoreUtil.isValidConfigurationGroupBracket(beginConfigurationGroup, allValidConfigurationGroups)) continue;
                ++applicBlockCount;
                applicabilityBlocks.add(WordCoreUtil.createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType.ConfigurationGroup, beginConfigurationGroup));
                continue;
            }
            if (endFeature != null && endFeature.toLowerCase().contains(FEATUREAPP)) {
                --applicBlockCount;
                if (applicabilityBlocks.isEmpty()) {
                    return true;
                }
                if (!WordCoreUtil.isInvalidFeatureBlock((ApplicabilityBlock)applicabilityBlocks.pop(), matcher, branch, validFeatureValues)) continue;
                return true;
            }
            if (endConfiguration != null && endConfiguration.toLowerCase().contains(CONFIGAPP)) {
                --applicBlockCount;
                if (applicabilityBlocks.isEmpty()) {
                    return true;
                }
                if (!WordCoreUtil.isInvalidConfigurationBlock((ApplicabilityBlock)applicabilityBlocks.pop(), matcher)) continue;
                return true;
            }
            if (endConfigurationGroup == null || !endConfigurationGroup.toLowerCase().contains(CONFIGGRPAPP)) continue;
            --applicBlockCount;
            if (applicabilityBlocks.isEmpty()) {
                return true;
            }
            if (!WordCoreUtil.isInvalidConfigurationGroupBlock((ApplicabilityBlock)applicabilityBlocks.pop(), matcher)) continue;
            return true;
        }
        return applicBlockCount != 0;
    }

    private static boolean isValidConfigurationBracket(String beginConfig, Set<String> allValidConfigurations) {
        String[] configs;
        beginConfig = WordCoreUtil.textOnly(beginConfig);
        int start = beginConfig.indexOf("[") + 1;
        int end = beginConfig.indexOf("]");
        String applicExpText = beginConfig.substring(start, end);
        String[] stringArray = configs = applicExpText.split("&|\\|");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            String config = stringArray[n2];
            String configKey = config.split("=")[0].trim().toUpperCase();
            if (!allValidConfigurations.contains(configKey)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isValidConfigurationGroupBracket(String beginConfigGroup, Set<String> allValidConfigurationGroups) {
        String[] configs;
        beginConfigGroup = WordCoreUtil.textOnly(beginConfigGroup);
        int start = beginConfigGroup.indexOf("[") + 1;
        int end = beginConfigGroup.indexOf("]");
        String applicExpText = beginConfigGroup.substring(start, end);
        String[] stringArray = configs = applicExpText.split("&|\\|");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            String config = stringArray[n2];
            String configKey = config.split("=")[0].trim().toUpperCase();
            if (!allValidConfigurationGroups.contains(configKey)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isInvalidConfigurationBlock(ApplicabilityBlock applicabilityBlock, Matcher matcher) {
        return applicabilityBlock.getType() != ApplicabilityBlock.ApplicabilityType.Configuration;
    }

    private static boolean isInvalidConfigurationGroupBlock(ApplicabilityBlock applicabilityBlock, Matcher matcher) {
        return applicabilityBlock.getType() != ApplicabilityBlock.ApplicabilityType.ConfigurationGroup;
    }

    private static boolean isInvalidFeatureBlock(ApplicabilityBlock applicabilityBlock, Matcher matcher, BranchId branch, HashCollection<String, String> validFeatureValues) {
        if (applicabilityBlock.getType() != ApplicabilityBlock.ApplicabilityType.Feature) {
            return true;
        }
        String applicabilityExpression = applicabilityBlock.getApplicabilityExpression();
        return WordCoreUtil.isExpressionInvalid(applicabilityExpression, branch, validFeatureValues);
    }

    private static ApplicabilityBlock createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType applicType, String beginExpression) {
        ApplicabilityBlock beginApplic = new ApplicabilityBlock(applicType);
        beginExpression = beginExpression.replace(" [", "[");
        beginApplic.setApplicabilityExpression(beginExpression);
        return beginApplic;
    }

    public static String textOnly(String str) {
        str = paragraphPattern.matcher(str).replaceAll(" ");
        str = tagKiller.matcher(str).replaceAll("").trim();
        return Xml.unescape((String)str).toString();
    }

    public static boolean isExpressionInvalid(String expression, BranchId branch, HashCollection<String, String> validFeatureValues) {
        ApplicabilityGrammarLexer lex = new ApplicabilityGrammarLexer((CharStream)new ANTLRStringStream(expression.toUpperCase()));
        ApplicabilityGrammarParser parser = new ApplicabilityGrammarParser((TokenStream)new CommonTokenStream((TokenSource)lex));
        try {
            parser.start();
        }
        catch (RecognitionException recognitionException) {
            return true;
        }
        HashMap<String, List<String>> featureIdValuesMap = parser.getIdValuesMap();
        if (featureIdValuesMap.isEmpty()) {
            return true;
        }
        for (String featureId : featureIdValuesMap.keySet()) {
            if (validFeatureValues.containsKey((Object)(featureId = featureId.trim()).toUpperCase())) {
                List<String> values = featureIdValuesMap.get(featureId);
                if (values.contains("Default")) continue;
                Collection validValues = validFeatureValues.getValues((Object)featureId.toUpperCase());
                for (String val : values) {
                    if ((val = val.trim()).equals("(") || val.equals(")") || val.equals("|") || val.equals("&") || WordCoreUtil.containsIgnoreCase(validValues, val)) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean containsIgnoreCase(Collection<String> validValues, String val) {
        for (String validValue : validValues) {
            if (!validValue.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    public static int endIndexOf(String str, String regex) {
        int toReturn = -1;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            toReturn = matcher.end();
        }
        return toReturn;
    }

    public static int lastIndexOf(String str, String regex) {
        int toReturn = -1;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            toReturn = matcher.start();
        }
        return toReturn;
    }

    public static int indexOf(String str, String regex) {
        int toReturn = -1;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            toReturn = matcher.start();
        }
        return toReturn;
    }
}

