/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.tx.IAtsTeamDefinitionArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.actions.wizard.AbstractWizardItem;
import org.eclipse.osee.ats.ide.actions.wizard.WizardFields;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.support.test.util.TestUtil;

public class DemoPlAndSawWizardItem
extends AbstractWizardItem {
    private static Collection<IAtsTeamDefinition> demoTeamDefs;

    public DemoPlAndSawWizardItem() {
        super((AtsApi)AtsApiService.get());
    }

    public Collection<WizardFields> getFields(IAtsTeamDefinition teamDef) {
        ArrayList<WizardFields> fields = new ArrayList<WizardFields>();
        fields.add(WizardFields.Originator);
        fields.add(WizardFields.Assignees);
        fields.add(WizardFields.Points);
        fields.add(WizardFields.UnPlannedWork);
        fields.add(WizardFields.Sprint);
        fields.add(WizardFields.TargetedVersion);
        fields.add(WizardFields.FeatureGroup);
        fields.add(WizardFields.WorkPackage);
        return fields;
    }

    protected boolean hasWizardXWidgetExtensions(IAtsTeamDefinition teamDef) {
        if (!TestUtil.isDemoDb()) {
            return false;
        }
        return this.getDemoTeamDefs().contains(teamDef);
    }

    public boolean hasWizardXWidgetExtensions(Collection<IAtsActionableItem> ais) {
        Collection<IAtsTeamDefinition> ceeTeamDefs;
        if (!TestUtil.isDemoDb()) {
            return false;
        }
        Collection teams = AtsApiService.get().getActionableItemService().getImpactedTeamDefs(ais);
        ArrayList intersect = Collections.setIntersection((Collection)teams, ceeTeamDefs = this.getDemoTeamDefs());
        return !intersect.isEmpty();
    }

    private Collection<IAtsTeamDefinition> getDemoTeamDefs() {
        if (demoTeamDefs == null) {
            demoTeamDefs = new ArrayList<IAtsTeamDefinition>();
            for (IAtsTeamDefinitionArtifactToken tok : Arrays.asList(DemoArtifactToken.SAW_PL_ARB_TeamDef, DemoArtifactToken.SAW_PL_TeamDef, DemoArtifactToken.SAW_PL_CR_TeamDef, DemoArtifactToken.SAW_PL_HW_TeamDef, DemoArtifactToken.SAW_PL_Code_TeamDef, DemoArtifactToken.SAW_PL_Test_TeamDef, DemoArtifactToken.SAW_PL_SW_Design_TeamDef, DemoArtifactToken.SAW_PL_Requirements_TeamDef, DemoArtifactToken.SAW_PL_ARB_TeamDef, DemoArtifactToken.SAW_SW, DemoArtifactToken.SAW_HW, DemoArtifactToken.SAW_Code, DemoArtifactToken.SAW_Test, DemoArtifactToken.SAW_SW_Design, DemoArtifactToken.SAW_Requirements)) {
                TeamDefinition teamDef = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)tok);
                demoTeamDefs.add((IAtsTeamDefinition)teamDef);
            }
        }
        return demoTeamDefs;
    }

    public String getName() {
        return "SAW PL Demo Development";
    }
}

