/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.populate;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TeamWorkFlowManager;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public interface IPopulateDemoDatabase {
    public static final boolean debug = false;
    public static final boolean isSuccessful = true;
    public static final TeamState toState = TeamState.Implement;

    default public boolean isDebug() {
        return false;
    }

    default public void run() {
    }

    default public void setValidationRequired(IAtsChangeSet changes, IAtsTeamWorkflow teamWf) {
        changes.setSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired, (Object)true);
    }

    default public void setVersion(IAtsTeamWorkflow teamWf, ArtifactToken versionToken, IAtsChangeSet changes) {
        Version version = AtsApiService.get().getVersionService().getVersionById((ArtifactId)versionToken);
        AtsApiService.get().getVersionService().setTargetedVersion(teamWf, (IAtsVersion)version, changes);
    }

    default public void transitionTo(IAtsTeamWorkflow teamWf, TeamState state, IAtsChangeSet changes) {
        TeamWorkFlowManager dtwm = new TeamWorkFlowManager(teamWf, (AtsApi)AtsApiService.get(), new TransitionOption[]{TransitionOption.OverrideAssigneeCheck, TransitionOption.OverrideTransitionValidityCheck});
        Result result = dtwm.transitionTo(state, (AtsUser)teamWf.getAssignees().iterator().next(), false, changes);
        if (result.isFalse()) {
            throw new OseeCoreException("Error transitioning [%s] to state [%s]: [%s]", new Object[]{teamWf.toStringWithId(), state, result.getText()});
        }
        if (!teamWf.isCompletedOrCancelled()) {
            teamWf.getStateMgr().setAssignees(AtsApiService.get().getTeamDefinitionService().getLeads(teamWf.getTeamDefinition()));
        }
    }
}

