/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class Collections {
    public static Object[] EMPTY_ARRAY = new Object[0];

    public static List<String> fromString(String rawValue, String seperator) {
        return Collections.fromString(rawValue, seperator, Function.identity());
    }

    public static <R> List<R> fromString(String rawValue, Function<String, R> function) {
        return Collections.fromString(rawValue, ",", function);
    }

    public static <R> List<R> fromString(String rawValue, String seperator, Function<String, R> function) {
        List toReturn;
        if (Strings.isValid(rawValue)) {
            String[] entries = rawValue.split(seperator);
            toReturn = new ArrayList(entries.length);
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String token = entry.trim();
                if (Strings.isValid(token)) {
                    toReturn.add(function.apply(token));
                }
                ++n2;
            }
        } else {
            toReturn = java.util.Collections.emptyList();
        }
        return toReturn;
    }

    public static <T> String toString(Iterable<T> items, String prefix, String separator, String suffix) {
        return Collections.toString(items, prefix, separator, suffix, String::valueOf);
    }

    public static <T> String toString(Iterable<T> items, String separator, Function<T, String> function) {
        return Collections.toString(items, null, separator, null, function);
    }

    public static <T> String toString(Iterable<T> items, String prefix, String separator, String suffix, Function<T, String> function) {
        StringBuilder strB = new StringBuilder();
        Collections.appendToBuilder(items, prefix, separator, suffix, function, strB);
        return strB.toString();
    }

    public static <T> void appendToBuilder(Iterable<T> items, String separator, StringBuilder strB) {
        Collections.appendToBuilder(items, null, separator, null, String::valueOf, strB);
    }

    public static <T> void appendToBuilder(Iterable<T> items, String prefix, String separator, String suffix, Function<T, String> function, StringBuilder strB) {
        if (items == null) {
            return;
        }
        if (prefix != null) {
            strB.append(prefix);
        }
        boolean first = true;
        for (T item : items) {
            if (first) {
                first = false;
            } else {
                strB.append(separator);
            }
            strB.append(function.apply(item));
        }
        if (suffix != null) {
            strB.append(suffix);
        }
    }

    public static String toString(String[] items, String separator) {
        return Collections.toString(items, null, separator, null);
    }

    public static String toString(String[] items, String prefix, String separator, String suffix) {
        if (items == null) {
            return "";
        }
        StringBuilder strB = new StringBuilder();
        if (prefix != null) {
            strB.append(prefix);
        }
        boolean first = true;
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (first) {
                first = false;
            } else {
                strB.append(separator);
            }
            strB.append(item);
            ++n2;
        }
        if (suffix != null) {
            strB.append(suffix);
        }
        return strB.toString();
    }

    public static String toString(String separator, Object ... items) {
        return Collections.toString(separator, Arrays.asList(items));
    }

    public static String toString(String separator, Iterable<?> c) {
        return Collections.toString(c, null, separator, null);
    }

    public static <A> List<Collection<A>> subDivide(List<A> collection, int size) {
        ArrayList<Collection<A>> result = new ArrayList<Collection<A>>();
        int i = 0;
        while (i < collection.size() / size + 1) {
            int maxLength = i * size + size > collection.size() ? collection.size() : i * size + size;
            ArrayList<A> sublist = new ArrayList<A>();
            int j = i * size;
            while (j < maxLength) {
                sublist.add(collection.get(j));
                ++j;
            }
            result.add(sublist);
            ++i;
        }
        return result;
    }

    public static <A> Collection<A> unique(Collection<A> collection) {
        HashSet<A> result = new HashSet<A>();
        result.addAll(collection);
        return result;
    }

    public static <T> List<T> setComplement(Collection<? extends T> set_A, Collection<? extends T> set_B) {
        ArrayList<T> complement = new ArrayList<T>(set_A.size());
        for (T obj : set_A) {
            if (set_B.contains(obj)) continue;
            complement.add(obj);
        }
        return complement;
    }

    public static <T> ArrayList<T> setIntersection(Collection<T> listA, Collection<T> listB) {
        ArrayList<T> intersection = new ArrayList<T>(listA.size());
        for (T obj : listA) {
            if (!listB.contains(obj)) continue;
            intersection.add(obj);
        }
        return intersection;
    }

    public static <T> Set<T> setUnion(Collection<T> ... lists) {
        HashSet<T> union = new HashSet<T>(lists[0].size() * 2);
        int x = 0;
        while (x < lists.length) {
            union.addAll(lists[x]);
            ++x;
        }
        return union;
    }

    public static <T> boolean isEqual(Collection<T> listA, Collection<T> listB) {
        if (listA.size() != listB.size()) {
            return false;
        }
        return listA.size() == Collections.setIntersection(listA, listB).size();
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        LinkedHashSet<T> set = null;
        if (collection instanceof Set) {
            set = (LinkedHashSet<T>)collection;
        } else {
            set = new LinkedHashSet<T>();
            set.addAll(collection);
        }
        return set;
    }

    public static <T> Set<T> asHashSet(T ... objects) {
        HashSet<T> objs = new HashSet<T>();
        if (objects != null) {
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T obj = TArray[n2];
                objs.add(obj);
                ++n2;
            }
        }
        return objs;
    }

    public static List<Object> getAggregateTree(List<Object> items, int maxPerList) {
        if (items == null) {
            throw new IllegalArgumentException("items can not be null");
        }
        if (maxPerList < 2) {
            throw new IllegalArgumentException("maxPerList can not be less than 2");
        }
        if (items.size() > maxPerList) {
            return Collections.recursiveAggregateTree(items, maxPerList);
        }
        return new ArrayList<Object>(items);
    }

    private static ArrayList<Object> recursiveAggregateTree(List<Object> items, int maxPerList) {
        if (items.size() > maxPerList) {
            ArrayList<Object> aggregateList = new ArrayList<Object>(maxPerList);
            ArrayList<Object> childList = null;
            for (Object item : items) {
                if (childList == null || childList.size() == maxPerList) {
                    childList = new ArrayList<Object>(maxPerList);
                    aggregateList.add(childList);
                }
                childList.add(item);
            }
            if (childList != null) {
                childList.trimToSize();
            }
            aggregateList = Collections.recursiveAggregateTree(aggregateList, maxPerList);
            aggregateList.trimToSize();
            return aggregateList;
        }
        return (ArrayList)items;
    }

    private static <A> List<A> cast(Class<A> clazz, Collection<? extends Object> objects, CastOption castOption) {
        ArrayList<Object> results = new ArrayList<Object>(objects.size());
        for (Object object : objects) {
            if (object == null || castOption != CastOption.ALL && (castOption != CastOption.MATCHING || !clazz.isAssignableFrom(object.getClass()))) continue;
            results.add(object);
        }
        return results;
    }

    public static <A> List<A> castAll(Collection<?> objects) {
        ArrayList results = new ArrayList(objects.size());
        for (Object object : objects) {
            results.add(object);
        }
        return results;
    }

    public static <F extends T, T> List<T> cast(Collection<F> from) {
        return Collections.transform(from, r -> r);
    }

    public static <A> List<A> castAll(Class<A> clazz, Collection<? extends Object> objects) {
        return Collections.cast(clazz, objects, CastOption.ALL);
    }

    public static <A> List<A> castMatching(Class<A> clazz, Collection<? extends Object> objects) {
        return Collections.cast(clazz, objects, CastOption.MATCHING);
    }

    public static <A> boolean moveItem(List<A> currentOrder, A itemToAdd, A targetItem, boolean insertAfter) {
        int newIndex = currentOrder.indexOf(targetItem);
        if (newIndex < 0 || newIndex > currentOrder.size() - 1) {
            return false;
        }
        int oldIndex = currentOrder.indexOf(itemToAdd);
        if (oldIndex < 0 || oldIndex > currentOrder.size() - 1) {
            return false;
        }
        currentOrder.remove(itemToAdd);
        if (insertAfter) {
            newIndex = newIndex > oldIndex ? newIndex : newIndex + 1;
        } else {
            int n = newIndex = newIndex > oldIndex ? newIndex - 1 : newIndex;
        }
        if (newIndex > currentOrder.size()) {
            currentOrder.add(itemToAdd);
        } else {
            currentOrder.add(newIndex, itemToAdd);
        }
        return true;
    }

    public static <T> void flatten(Collection<T> input, List<T> flattenedOutput) {
        for (T item : input) {
            if (item instanceof Collection) {
                Collections.flatten((Collection)item, flattenedOutput);
                continue;
            }
            flattenedOutput.add(item);
        }
    }

    public static <T> Set<T> hashSet(T ... items) {
        HashSet<T> result = new HashSet<T>();
        T[] TArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            result.add(item);
            ++n2;
        }
        return result;
    }

    public static <F, T> List<T> transform(Collection<F> from, Function<F, T> function) {
        if (from.isEmpty()) {
            return java.util.Collections.emptyList();
        }
        ArrayList<T> toReturn = new ArrayList<T>(from.size());
        for (F item : from) {
            toReturn.add(function.apply(item));
        }
        return toReturn;
    }

    public static <T> T exactlyOne(Collection<T> items) {
        if (items.size() > 1) {
            throw new MultipleItemsExist("Expected exactly 1, but found %s", items.size());
        }
        if (items.size() == 0) {
            throw new OseeCoreException("Expected exactly 1, but found none", new Object[0]);
        }
        if (items instanceof List) {
            return (T)((List)items).get(0);
        }
        return items.iterator().next();
    }

    public static <T> T oneOrSentinel(Collection<T> items, T sentinel) {
        if (items.size() > 1) {
            throw new MultipleItemsExist("Expected at most 1, but found %s", items.size());
        }
        if (items.size() == 1) {
            if (items instanceof List) {
                return (T)((List)items).get(0);
            }
            return items.iterator().next();
        }
        return sentinel;
    }

    public static enum CastOption {
        MATCHING,
        ALL;

    }
}

