/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.ReservedCharacters;

public class XmlTextInputStream
extends BufferedInputStream {
    private static final String START_PARAGRAPH_REGEX = "<w:p( .+)?>";
    private static final String STOP_PARAGRAPH = "</w:p>";
    private static final String START_WORDML_TEXT_REGEX = "<w:t( .+)?>";
    private static final String END_WORDML_TEXT = "</w:t>";
    private static final String LINE_BREAK = "<w:br/>";
    private static final String TAB_REGEX = "<w:tab( .+)?/>";
    private static final char[] OSEE_LINK_BEGIN = "OSEE_LINK(".toCharArray();
    private static final char OSEE_LINK_END = ')';
    private IReadHelper readHelper;

    public XmlTextInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public XmlTextInputStream(String input) throws UnsupportedEncodingException {
        this(new ByteArrayInputStream(input.getBytes("UTF-8")));
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.readHelper == null) {
            this.readHelper = Lib.isWordML(this.in) ? new WordMlReadHelper() : new XmlReadHelper();
        }
        int value = this.readHelper.process(super.read());
        value = this.checkForSpecialCharacters(value);
        return value;
    }

    private int checkForSpecialCharacters(int value) throws IOException {
        char currChar = (char)value;
        if (currChar == '&' && this.available() > 0) {
            boolean needsReset = true;
            super.mark(10);
            this.readHelper.saveState();
            try {
                StringBuilder specialCharBuffer = new StringBuilder();
                specialCharBuffer.append(currChar);
                int readCount = 0;
                while (currChar != ';' && readCount < 10 && super.available() > 0) {
                    currChar = (char)this.readHelper.process(super.read());
                    specialCharBuffer.append(currChar);
                    ++readCount;
                }
                Character reserved = ReservedCharacters.toCharacter(specialCharBuffer.toString());
                if (reserved != null) {
                    needsReset = false;
                    value = reserved.charValue();
                }
            }
            finally {
                if (needsReset) {
                    super.reset();
                    this.readHelper.restoreState();
                }
            }
        }
        return value;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        int i = 1;
        try {
            while (i < len) {
                c = this.read();
                if (c != -1) {
                    b[off + i] = (byte)c;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return i;
    }

    private int readFromOriginalBuffer() throws IOException {
        return super.read();
    }

    private static interface IReadHelper {
        public int process(int var1) throws IOException;

        public void saveState();

        public void restoreState() throws IOException;
    }

    private final class WordMlReadHelper
    implements IReadHelper {
        private boolean partOfTag = false;
        private boolean collect = false;
        private boolean isCarriageReturn = false;
        private boolean isStartOfParagraph = false;
        private boolean isBreak = false;
        private final StringBuilder buffer = new StringBuilder();
        private boolean wasSaved = false;
        private boolean lastPartOfTag = false;
        private boolean lastCollect = false;
        private boolean lastIsCarriageReturn = false;
        private boolean lastIsStartOfParagraph = false;
        private int linkIdx = 0;
        private boolean foundLink = false;

        @Override
        public int process(int value) throws IOException {
            this.isStartOfParagraph = false;
            this.isBreak = false;
            if ((char)value == '<') {
                this.partOfTag = true;
                this.buffer.append((char)value);
            } else {
                this.linkIdx = (char)value == OSEE_LINK_BEGIN[this.linkIdx] ? this.linkIdx + 1 : 0;
            }
            while ((this.partOfTag || this.isCarriageReturn || !this.isStartOfParagraph && !this.collect && !this.isBreak && !this.foundLink) && XmlTextInputStream.this.available() > 0) {
                value = XmlTextInputStream.this.readFromOriginalBuffer();
                if ((char)value == '<') {
                    this.partOfTag = true;
                } else if ((char)value == OSEE_LINK_BEGIN[this.linkIdx++]) {
                    if (OSEE_LINK_BEGIN.length == this.linkIdx) {
                        this.foundLink = true;
                        this.linkIdx = 0;
                    }
                } else {
                    this.linkIdx = 0;
                }
                if (this.partOfTag) {
                    this.buffer.append((char)value);
                }
                this.isCarriageReturn = value == 13 || value == 10;
                if ((char)value != '>') continue;
                this.partOfTag = false;
                String tag = this.buffer.toString();
                if (tag.matches(XmlTextInputStream.START_WORDML_TEXT_REGEX)) {
                    this.collect = true;
                } else if (tag.equals(XmlTextInputStream.END_WORDML_TEXT)) {
                    this.collect = false;
                } else if (tag.matches(XmlTextInputStream.START_PARAGRAPH_REGEX)) {
                    this.isStartOfParagraph = true;
                } else if (tag.startsWith(XmlTextInputStream.STOP_PARAGRAPH)) {
                    this.isStartOfParagraph = false;
                } else if (tag.startsWith(XmlTextInputStream.LINE_BREAK)) {
                    this.isBreak = true;
                } else if (tag.matches(XmlTextInputStream.TAB_REGEX)) {
                    this.isBreak = true;
                }
                this.buffer.delete(0, this.buffer.length());
                value = 32;
                if (this.isStartOfParagraph || this.isBreak || XmlTextInputStream.this.available() <= 0) continue;
                value = XmlTextInputStream.this.readFromOriginalBuffer();
                if ((char)value == '<') {
                    this.partOfTag = true;
                    this.buffer.append((char)value);
                    continue;
                }
                if ((char)value == OSEE_LINK_BEGIN[this.linkIdx++]) continue;
                this.linkIdx = 0;
            }
            if (this.foundLink && (char)value == ')') {
                this.foundLink = false;
                this.linkIdx = 0;
            }
            if (XmlTextInputStream.this.available() <= 0) {
                value = -1;
            }
            return value;
        }

        @Override
        public void restoreState() throws IOException {
            if (!this.wasSaved) {
                throw new IOException("Save state was not called before restore.");
            }
            this.partOfTag = this.lastPartOfTag;
            this.collect = this.lastCollect;
            this.isStartOfParagraph = this.lastIsStartOfParagraph;
            this.isCarriageReturn = this.lastIsCarriageReturn;
            this.wasSaved = false;
        }

        @Override
        public void saveState() {
            this.wasSaved = true;
            this.lastPartOfTag = this.partOfTag;
            this.lastCollect = this.collect;
            this.lastIsStartOfParagraph = this.isStartOfParagraph;
            this.lastIsCarriageReturn = this.isCarriageReturn;
        }
    }

    private final class XmlReadHelper
    implements IReadHelper {
        private boolean partOfTag = false;
        private boolean isCarriageReturn = false;
        private boolean wasSaved = false;
        private boolean lastPartOfTag = false;
        private boolean lastIsCarriageReturn = false;

        @Override
        public int process(int value) throws IOException {
            if ((char)value == '<') {
                this.partOfTag = true;
            }
            while ((this.partOfTag || this.isCarriageReturn) && XmlTextInputStream.this.available() > 0) {
                value = XmlTextInputStream.this.readFromOriginalBuffer();
                this.isCarriageReturn = value == 13 || value == 10;
                if ((char)value != '>') continue;
                this.partOfTag = false;
                int n = value = XmlTextInputStream.this.available() > 0 ? 32 : -1;
            }
            return value;
        }

        @Override
        public void restoreState() throws IOException {
            if (!this.wasSaved) {
                throw new IOException("Save state was not called before restore.");
            }
            this.partOfTag = this.lastPartOfTag;
            this.isCarriageReturn = this.lastIsCarriageReturn;
            this.wasSaved = false;
        }

        @Override
        public void saveState() {
            this.wasSaved = true;
            this.lastPartOfTag = this.partOfTag;
            this.lastIsCarriageReturn = this.isCarriageReturn;
        }
    }
}

