/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class DispoSourceFileResource {
    private final DispoApi dispoApi;
    private final BranchId branch;
    private final String setId;

    public DispoSourceFileResource(DispoApi dispoApi, BranchId branch, String setId) {
        this.dispoApi = dispoApi;
        this.branch = branch;
        this.setId = setId;
    }

    @Path(value="{fileName}/{fileNumber}")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response getDispoItemsById(@PathParam(value="fileName") String fileName, @PathParam(value="fileNumber") String fileNumber) {
        DispoSet set;
        String fullPath;
        if (!fileName.endsWith(".LIS")) {
            fileName = fileName.replaceAll(this.dispoApi.getConfig().getFileExtRegex(), ".LIS");
        }
        if (!new File(fullPath = String.valueOf((set = this.dispoApi.getDispoSetById(this.branch, this.setId)).getImportPath()) + File.separator + "vcast" + File.separator + fileName).exists()) {
            String regex = "\\.2\\.";
            fullPath = fullPath.replaceAll(regex, String.format(".%s.2.", fileNumber));
        }
        final File result = new File(fullPath);
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream outputStream) throws WebApplicationException {
                FileInputStream inputStream = null;
                OutputStreamWriter writer = null;
                try {
                    try {
                        int c;
                        inputStream = new FileInputStream(result);
                        writer = new OutputStreamWriter(outputStream, "UTF-8");
                        while ((c = inputStream.read()) != -1) {
                            ((Writer)writer).write(c);
                        }
                        outputStream.flush();
                    }
                    catch (IOException ex) {
                        throw new OseeCoreException((Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    Lib.close(inputStream);
                    Lib.close(writer);
                    throw throwable;
                }
                Lib.close((AutoCloseable)inputStream);
                Lib.close((AutoCloseable)writer);
            }
        };
        String contentDisposition = String.format("attachment; filename=\"%s\"; creation-date=\"%s\"", fileName, new Date());
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)contentDisposition).type("application/text").build();
    }
}

