/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

@Provider
public class ArtifactJsonWriter
implements MessageBodyWriter<Object> {
    private JsonFactory jsonFactory;
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void start() {
        this.jsonFactory = this.orcsApi.jaxRsApi().getFactory();
    }

    public void stop() {
        this.jsonFactory = null;
    }

    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean result = false;
        if (Iterable.class.isAssignableFrom(type) && genericType.getClass().isAssignableFrom(ArtifactReadable.class) && MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            result = true;
        }
        return result;
    }

    private boolean matches(Class<? extends Annotation> toMatch, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAssignableFrom(toMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator writer = null;
        if (type.isAssignableFrom(ArtifactReadable.class)) {
            ArtifactReadable artifact = (ArtifactReadable)object;
            try {
                writer = this.jsonFactory.createGenerator(entityStream);
                writer.writeStartObject();
                writer.writeNumberField("uuid", artifact.getUuid().longValue());
                if (this.matches(IdentityView.class, annotations)) {
                    writer.writeStringField("Name", artifact.getName());
                } else {
                    Collection attrTypes = this.orcsApi.tokenService().getAttributeTypes();
                    ResultSet attributes = artifact.getAttributes();
                    if (!attributes.isEmpty()) {
                        for (AttributeTypeGeneric attrType : attrTypes) {
                            Object value2;
                            List attributeValues;
                            if (!artifact.isAttributeTypeValid((AttributeTypeId)attrType) || (attributeValues = artifact.getAttributeValues((AttributeTypeToken)attrType)).isEmpty()) continue;
                            if (attributeValues.size() > 1) {
                                writer.writeArrayFieldStart(attrType.getName());
                                for (Object value2 : attributeValues) {
                                    writer.writeObject(value2);
                                }
                                writer.writeEndArray();
                                continue;
                            }
                            if (attributeValues.size() != 1) continue;
                            value2 = attributeValues.iterator().next();
                            writer.writeObjectField(attrType.getName(), value2);
                        }
                    }
                }
                writer.writeEndObject();
            }
            finally {
                if (writer != null) {
                    writer.flush();
                }
            }
        }
    }
}

