/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.applicability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ApplicabilityData;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BlockApplicabilityStageRequest;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.ConfigurationGroupDefinition;
import org.eclipse.osee.framework.core.data.CreateViewDefinition;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.rest.internal.writer.ApplicabilityFeatureMatrixStreamingOutput;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ApplicabilityEndpointImpl
implements ApplicabilityEndpoint {
    private final OrcsApi orcsApi;
    private final BranchId branch;
    private final ApplicabilityQuery applicabilityQuery;
    private final UserId account;
    private final OrcsApplicability ops;

    public ApplicabilityEndpointImpl(OrcsApi orcsApi, BranchId branch, UserId account) {
        this.orcsApi = orcsApi;
        this.branch = branch;
        this.applicabilityQuery = orcsApi.getQueryFactory().applicabilityQuery();
        this.account = account;
        this.ops = orcsApi.getApplicabilityOps();
    }

    public Collection<ApplicabilityToken> getApplicabilityTokens() {
        return this.applicabilityQuery.getApplicabilityTokens(this.branch).values();
    }

    public Collection<String> getPossibleApplicabilities() {
        return this.applicabilityQuery.getPossibleApplicabilities(this.branch);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> artIds) {
        return this.applicabilityQuery.getApplicabilityTokens(artIds, this.branch);
    }

    public ApplicabilityToken getApplicabilityToken(ArtifactId artId) {
        return this.applicabilityQuery.getApplicabilityToken(artId, this.branch);
    }

    public List<ApplicabilityId> getApplicabilitiesReferenced(ArtifactId artifact) {
        return this.applicabilityQuery.getApplicabilitiesReferenced(artifact, this.branch);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokensForArts(Collection<? extends ArtifactId> artIds) {
        ArrayList<Pair<ArtifactId, ApplicabilityToken>> artToApplicToken = new ArrayList<Pair<ArtifactId, ApplicabilityToken>>();
        for (ArtifactId artifactId : artIds) {
            artToApplicToken.add((Pair<ArtifactId, ApplicabilityToken>)new Pair((Object)artifactId, (Object)this.getApplicabilityToken(artifactId)));
        }
        return artToApplicToken;
    }

    public List<ApplicabilityToken> getApplicabilityReferenceTokens(ArtifactId artifact) {
        return this.applicabilityQuery.getApplicabilityReferenceTokens(artifact, this.branch);
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId view) {
        return this.applicabilityQuery.getViewApplicabilityTokens(view, this.branch);
    }

    public List<ArtifactToken> getViews() {
        return this.applicabilityQuery.getViewsForBranch(this.branch);
    }

    public List<ArtifactToken> getCfgGroup() {
        return this.applicabilityQuery.getConfigurationGroupsForBranch(this.branch);
    }

    public List<FeatureDefinition> getFeatureDefinitionData() {
        return this.applicabilityQuery.getFeatureDefinitionData(this.branch);
    }

    public List<BranchId> getAffectedBranches(Long injectDateMs, Long removalDateMs, List<ApplicabilityId> applicabilityIds) {
        return this.applicabilityQuery.getAffectedBranches(injectDateMs, removalDateMs, applicabilityIds, this.branch);
    }

    public List<BranchId> getAffectedBranches(TransactionId injectionTx, TransactionId removalTx, List<ApplicabilityId> applicabilityIds) {
        return this.applicabilityQuery.getAffectedBranches(injectionTx, removalTx, applicabilityIds, this.branch);
    }

    public TransactionToken setApplicability(ApplicabilityId applicId, List<? extends ArtifactId> artifacts) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return TransactionToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Set Applicability Ids for Artifacts");
        tx.setApplicability(applicId, artifacts);
        return tx.commit();
    }

    public TransactionToken setApplicabilityByString(String applicTag, List<? extends ArtifactId> artifacts) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return TransactionToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Set Applicability Ids for Artifacts");
        Long putIfAbsent = this.orcsApi.getKeyValueOps().putIfAbsent(applicTag);
        ApplicabilityToken applicId = new ApplicabilityToken(putIfAbsent, applicTag);
        tx.setApplicability((ApplicabilityId)applicId, artifacts);
        return tx.commit();
    }

    public TransactionToken setApplicabilityReference(List<ApplicabilityData> appDatas) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return TransactionToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Set Reference Applicability Ids for Artifacts");
        HashMap<ArtifactId, List> artToApplMap = new HashMap<ArtifactId, List>();
        for (ApplicabilityData data : appDatas) {
            artToApplMap.put(data.getArtifact(), Collections.castAll((Collection)data.getApplIds()));
        }
        tx.setApplicabilityReference(artToApplMap);
        return tx.commit();
    }

    public XResultData createApplicabilityForView(ArtifactId viewId, String applicability) {
        XResultData results = this.isAccess();
        UserId user = this.account;
        if (user == null) {
            user = SystemUser.OseeSystem;
        }
        if (results.isErrors()) {
            return results;
        }
        return this.ops.createApplicabilityForView(viewId, applicability, user, this.branch);
    }

    public XResultData validate() {
        XResultData results = this.isAccess();
        UserId user = this.account;
        if (user == null) {
            user = SystemUser.OseeSystem;
        }
        results = this.ops.validateCompoundApplicabilities(this.branch, user, false);
        return results;
    }

    public XResultData removeApplicabilityFromView(ArtifactId viewId, String applicability) {
        XResultData results = this.isAccess();
        UserId user = this.account;
        if (user == null) {
            user = SystemUser.OseeSystem;
        }
        if (results.isErrors()) {
            return results;
        }
        return this.ops.removeApplicabilityFromView(this.branch, viewId, applicability, user);
    }

    public void addMissingApplicabilityFromParentBranch() {
        this.orcsApi.getBranchOps().addMissingApplicabilityFromParentBranch(this.branch);
    }

    public ArtifactId getVersionConfig(ArtifactId version) {
        return this.applicabilityQuery.getVersionConfig(version, this.branch);
    }

    public String getViewTable(String filter) {
        return this.applicabilityQuery.getViewTable(this.branch, filter);
    }

    public String getConfigMatrix(String matrixType, String filter) {
        String mType = "all";
        if (matrixType != null) {
            mType = matrixType;
        }
        return this.applicabilityQuery.getConfigMatrix(this.branch, mType, filter);
    }

    public FeatureDefinition getFeature(String featureNameOrId) {
        return this.ops.getFeature(featureNameOrId, this.branch);
    }

    public XResultData updateFeature(FeatureDefinition feature) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.updateFeature(feature, this.branch, this.account);
    }

    public XResultData createFeature(FeatureDefinition feature) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.createFeature(feature, this.branch, this.account);
    }

    public XResultData deleteFeature(ArtifactId feature) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.deleteFeature(feature, this.branch, this.account);
    }

    public XResultData updateView(CreateViewDefinition view) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.updateView(view, this.branch, this.account);
    }

    public XResultData createView(CreateViewDefinition view) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.createView(view, this.branch, this.account);
    }

    public XResultData deleteView(@PathParam(value="id") String id) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.deleteView(id, this.branch, this.account);
    }

    public CreateViewDefinition getView(String id) {
        return this.ops.getView(id, this.branch);
    }

    public XResultData isAccess() {
        Branch brch;
        XResultData rd = new XResultData();
        if (OseeProperties.isInTest()) {
            rd.logf("Access granted to branch cause isInTest", new Object[0]);
        }
        if ((brch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(this.branch)).getResults().getAtMostOneOrNull()).getBranchType() == BranchType.WORKING) {
            rd.log("Access granted to working branch");
        } else {
            rd.error("Access denied to non-working branch");
        }
        return rd;
    }

    public XResultData createCfgGroup(ConfigurationGroupDefinition group) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.createCfgGroup(group, this.branch, this.account);
    }

    public XResultData updateCfgGroup(ConfigurationGroupDefinition group) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.updateCfgGroup(group, this.branch, this.account);
    }

    public XResultData relateCfgGroupToView(String groupId, String viewId) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.relateCfgGroupToView(groupId, viewId, this.branch, this.account);
    }

    public XResultData unrelateCfgGroupToView(String groupId, String viewId) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.unrelateCfgGroupToView(groupId, viewId, this.branch, this.account);
    }

    public XResultData deleteCfgGroup(String id) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.deleteCfgGroup(id, this.branch, this.account);
    }

    public XResultData syncCfgGroup(String id) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.syncConfigGroup(this.branch, id, this.account, null);
    }

    public XResultData syncCfgGroup() {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.syncConfigGroup(this.branch, this.account);
    }

    public Response getFeatureMatrixExcel(BranchId branchId, String filter) {
        ApplicabilityFeatureMatrixStreamingOutput streamingOutput = new ApplicabilityFeatureMatrixStreamingOutput(this.orcsApi, branchId, filter);
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)"attachment; filename=FeatureMatrix.xml");
        return builder.build();
    }

    public XResultData applyBlockVisibility(BlockApplicabilityStageRequest data) {
        return this.ops.applyApplicabilityToFiles(data, this.branch);
    }

    public XResultData refreshStagedFiles(BlockApplicabilityStageRequest data) {
        return this.ops.refreshStagedFiles(data, this.branch);
    }

    public XResultData startBlockVisibilityWatcher(BlockApplicabilityStageRequest data) {
        return this.ops.startWatcher(data, this.branch);
    }

    public XResultData stopBlockVisibilityWatcher() {
        return this.ops.stopWatcher();
    }

    public ConfigurationGroupDefinition getConfigurationGroup(String id) {
        return this.ops.getConfigurationGroup(id, this.branch);
    }

    public ApplicabilityToken getApplicabilityTokenFromId(String id) {
        Optional<ApplicabilityToken> findAny = this.getApplicabilityTokens().stream().filter(a -> a.getIdString().equals(id)).findAny();
        if (findAny.isPresent()) {
            return findAny.get();
        }
        return ApplicabilityToken.SENTINEL;
    }
}

