/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.net.URI;
import java.util.concurrent.Callable;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserTokens;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsMetaData;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;
import org.eclipse.osee.orcs.rest.model.DatastoreInfo;

public class DatastoreEndpointImpl
implements DatastoreEndpoint {
    @Context
    private UriInfo uriInfo;
    private final ActivityLog activityLog;
    private final OrcsAdmin adminOps;
    private final UserService userService;
    @HeaderParam(value="osee.account.id")
    private UserId accountId;

    public DatastoreEndpointImpl(OrcsApi orcsApi, ActivityLog activityLog) {
        this.activityLog = activityLog;
        this.adminOps = orcsApi.getAdminOps();
        this.userService = orcsApi.userService();
    }

    protected void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public DatastoreInfo getInfo() {
        Callable callable = this.adminOps.createFetchOrcsMetaData();
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        return this.asDatastoreInfo(metaData);
    }

    public TransactionId initialize() {
        TransactionId txId = this.adminOps.createDatastoreAndSystemBranches();
        this.adminOps.createDemoBranches();
        return txId;
    }

    public void synonyms() {
        this.activityLog.setEnabled(false);
        this.adminOps.createSynonymsAndGrants();
        this.activityLog.setEnabled(true);
    }

    public Response migrate() {
        this.activityLog.setEnabled(false);
        Callable callable = this.adminOps.migrateDatastore();
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        URI location = this.getDatastoreLocation(this.uriInfo);
        return Response.created((URI)location).entity((Object)this.asDatastoreInfo(metaData)).build();
    }

    private URI getDatastoreLocation(UriInfo uriInfo) {
        return uriInfo.getRequestUriBuilder().path("../").path("info").build(new Object[0]);
    }

    private DatastoreInfo asDatastoreInfo(OrcsMetaData metaData) {
        DatastoreInfo info = new DatastoreInfo();
        info.setProperties(metaData.getProperties());
        return info;
    }

    public TransactionId createUsers(UserTokens users) {
        return this.userService.createUsers((Iterable)users.getUsers(), "DatastoreEndpointImpl.createUsers()");
    }

    public void updateBootstrapUser() {
        this.adminOps.updateBootstrapUser(this.accountId);
    }
}

