/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.config.AtsViews;
import org.eclipse.osee.ats.api.config.IAtsConfigurationViewsProvider;
import org.eclipse.osee.ats.api.util.ColorColumns;
import org.eclipse.osee.ats.rest.internal.config.AtsConfigurationViewsService;
import org.eclipse.osee.ats.rest.internal.config.AtsDbConfigBase;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class UpdateAtsConfiguration {
    public static final String VIEWS_KEY = "views";
    private static final String VIEWS_EQUAL_KEY = "views=";
    public static final String COLOR_COLUMN_KEY = "colorColumns";
    public static final String VALID_STATE_NAMES_KEY = "validStateNames";
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;
    private final JaxRsApi jaxRsApi;

    public UpdateAtsConfiguration(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.jaxRsApi = orcsApi.jaxRsApi();
    }

    public XResultData createUpdateConfig(XResultData rd) {
        UserToken user = SystemUser.OseeSystem;
        ArtifactReadable atsConfigArt = (ArtifactReadable)AtsDbConfigBase.getOrCreateAtsConfig(this.atsApi);
        this.createUpdateConfigAttributes(atsConfigArt, (UserId)user, rd);
        try {
            this.createUpdateValidStateAttributes();
        }
        catch (Exception ex) {
            rd.errorf("Error in createUpdateValidStateAttributes [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }

    private List<String> getViewsJsonStrings() throws Exception {
        LinkedList<String> viewsJson = new LinkedList<String>();
        viewsJson.add(OseeInf.getResourceContents((String)"atsConfig/views.json", this.getClass()));
        for (IAtsConfigurationViewsProvider provider : AtsConfigurationViewsService.getViewsProviders()) {
            viewsJson.add(provider.getViewsJson());
        }
        return viewsJson;
    }

    private void createUpdateConfigAttributes(ArtifactReadable configArt, UserId userId, XResultData rd) {
        try {
            AtsViews databaseViews = this.atsApi.getConfigService().getConfigurations().getViews();
            for (String viewsJson : this.getViewsJsonStrings()) {
                AtsViews atsViews = (AtsViews)this.jaxRsApi.readValue(viewsJson, AtsViews.class);
                LinkedList<AtsAttributeValueColumn> toAdd = new LinkedList<AtsAttributeValueColumn>();
                for (AtsAttributeValueColumn defaultView : atsViews.getAttrColumns()) {
                    boolean found = false;
                    for (AtsAttributeValueColumn dbView : databaseViews.getAttrColumns()) {
                        boolean defaultViewNameValid;
                        boolean bl = defaultViewNameValid = Strings.isValid((String)dbView.getName()) && Strings.isValid((String)defaultView.getName());
                        if (defaultViewNameValid && dbView.getName().equals(defaultView.getName())) {
                            found = true;
                            break;
                        }
                        if (found || !dbView.getAttrTypeName().equals(defaultView.getAttrTypeName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    toAdd.add(defaultView);
                }
                databaseViews.getAttrColumns().addAll(toAdd);
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, userId, "Create Update Config Attributes");
            Iterator iterator = configArt.getAttributes((AttributeTypeToken)CoreAttributeTypes.GeneralStringData, DeletionFlag.EXCLUDE_DELETED).iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                AttributeReadable attributeReadable = (AttributeReadable)iterator.next();
                if (attributeReadable == null || !((String)attributeReadable.getValue()).startsWith(VIEWS_EQUAL_KEY)) continue;
                tx.setAttributeById((ArtifactId)configArt, (AttributeId)attributeReadable, this.getViewsAttrValue(databaseViews));
                rd.log("Create or update AtsConfig.VIEWS attribute\n");
                found = true;
                break;
            }
            if (!found) {
                tx.createAttribute((ArtifactId)configArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)this.getViewsAttrValue(databaseViews));
                rd.log("Creating VIEWS attribute\n");
            }
            tx.commit();
        }
        catch (Exception ex) {
            OseeLog.log(UpdateAtsConfiguration.class, (Level)Level.SEVERE, (Throwable)ex);
            rd.error("Error loading column views.json file (see log for details) " + ex.getLocalizedMessage());
        }
    }

    private String getViewsAttrValue(AtsViews defaultViews) {
        return VIEWS_EQUAL_KEY + this.jaxRsApi.toJson((Object)defaultViews);
    }

    private void createUpdateValidStateAttributes() throws Exception {
        Collection validStateNames = this.atsApi.getWorkDefinitionService().getAllValidStateNames(new XResultData());
        this.atsApi.setConfigValue(VALID_STATE_NAMES_KEY, Collections.toString((String)",", (Iterable)validStateNames));
    }

    public Collection<String> getValidStateNames(String stateNamesStr) {
        LinkedList<String> stateNames = new LinkedList<String>();
        if (Strings.isValid((String)stateNamesStr)) {
            String[] stringArray = stateNamesStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String stateName = stringArray[n2];
                stateNames.add(stateName);
                ++n2;
            }
        }
        return stateNames;
    }

    public AtsViews getConfigViews(String viewsStr) {
        AtsViews views = null;
        views = Strings.isValid((String)viewsStr) ? (AtsViews)this.jaxRsApi.readValue(viewsStr, AtsViews.class) : new AtsViews();
        return views;
    }

    public ColorColumns getColorColumns(String colorStr) {
        ColorColumns columns = null;
        columns = Strings.isValid((String)colorStr) ? (ColorColumns)this.jaxRsApi.readValue(colorStr, ColorColumns.class) : new ColorColumns();
        return columns;
    }
}

