/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.app;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.app.OseeAppResourceTokens;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.ClassBasedResourceToken;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.ResourceToken;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.template.engine.AppendableRule;
import org.eclipse.osee.template.engine.CompositeRule;
import org.eclipse.osee.template.engine.IdentifiableLongOptionsRule;
import org.eclipse.osee.template.engine.PageCreator;
import org.eclipse.osee.template.engine.PageFactory;

public class OseeAppletPage {
    private static final Pattern listAttributePattern = Pattern.compile("<input[^>]+?list=\"([^\"]+)");
    private final BranchQuery query;

    public OseeAppletPage(BranchQuery query) {
        this.query = query;
    }

    public String realizeApplet(String name, Class<?> clazz) {
        ClassBasedResourceToken valuesToken = new ClassBasedResourceToken(name, clazz);
        return this.realizeApplet(null, (ResourceToken)valuesToken);
    }

    public String realizeApplet(IResourceRegistry registry, String name, Class<?> clazz) {
        ClassBasedResourceToken valuesToken = new ClassBasedResourceToken(name, clazz);
        return this.realizeApplet(registry, (ResourceToken)valuesToken);
    }

    public String realizeApplet(IResourceRegistry registry, String name, Class<?> clazz, AppendableRule<?> ... rules) {
        ClassBasedResourceToken valuesToken = new ClassBasedResourceToken(name, clazz);
        PageCreator page = PageFactory.newPageCreatorWithRules((IResourceRegistry)registry, (ResourceToken)valuesToken, rules);
        return this.realizeApplet(page);
    }

    public String realizeApplet(IResourceRegistry registry, ResourceToken valuesToken) {
        PageCreator page = PageFactory.newPageCreator((IResourceRegistry)registry, (ResourceToken)valuesToken, (String[])new String[0]);
        return this.realizeApplet(page);
    }

    public String realizeApplet(PageCreator page) {
        String widgets = page.getValue("widgets");
        Matcher matcher = listAttributePattern.matcher(widgets);
        CompositeRule dataListsRule = new CompositeRule("dataLists");
        while (matcher.find()) {
            String listId = matcher.group(1);
            if (!listId.equals("baselineBranches") && !listId.equals("workingAndBaselineBranches") || dataListsRule.ruleExists(listId)) continue;
            Iterable<BranchToken> options = this.getBranchOptions(this.query, listId);
            dataListsRule.addRule((AppendableRule)new IdentifiableLongOptionsRule("", options, listId));
        }
        page.addSubstitution(new AppendableRule[]{dataListsRule});
        return page.realizePage(OseeAppResourceTokens.OseeAppHtml);
    }

    private Iterable<BranchToken> getBranchOptions(BranchQuery query, String listId) {
        BranchType[] branchTypeArray;
        if (listId.equals("baselineBranches")) {
            BranchType[] branchTypeArray2 = new BranchType[1];
            branchTypeArray = branchTypeArray2;
            branchTypeArray2[0] = BranchType.BASELINE;
        } else {
            BranchType[] branchTypeArray3 = new BranchType[2];
            branchTypeArray3[0] = BranchType.BASELINE;
            branchTypeArray = branchTypeArray3;
            branchTypeArray3[1] = BranchType.WORKING;
        }
        BranchType[] branchTypes = branchTypeArray;
        query.andIsOfType(branchTypes);
        query.andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED});
        return query.getResultsAsId();
    }
}

