/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.cache.admin.internal;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.cache.admin.CacheKeysLoader;

public class LoadingCacheProxy<K, V>
implements Cache<K, V> {
    private final LoadingCache<K, V> proxied;
    private final CacheKeysLoader<K> keyProvider;

    public LoadingCacheProxy(LoadingCache<K, V> proxied, CacheKeysLoader<K> keyProvider) {
        this.proxied = proxied;
        this.keyProvider = keyProvider;
    }

    @Override
    public V getIfPresent(K key) {
        return (V)this.proxied.getIfPresent(key);
    }

    @Override
    public Iterable<V> getAllPresent() {
        Iterable<K> keys = this.getAllKeysPresent();
        return this.getIfPresent(keys).values();
    }

    @Override
    public Iterable<? extends K> getAllKeysPresent() {
        return Iterables.unmodifiableIterable(this.proxied.asMap().keySet());
    }

    @Override
    public Iterable<? extends K> getAllKeys() throws Exception {
        Iterable<K> iterator1 = this.getAllKeysPresent();
        Iterable<K> iterator2 = this.keyProvider.getAllKeys();
        Iterable joined = Iterables.concat(iterator1, iterator2);
        return Sets.newHashSet((Iterable)joined);
    }

    @Override
    public Map<K, V> getIfPresent(Iterable<? extends K> keys) {
        return this.proxied.getAllPresent(keys);
    }

    @Override
    public Map<K, V> get(Iterable<? extends K> keys) throws Exception {
        ImmutableMap items = null;
        try {
            items = this.proxied.getAll(keys);
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            throw new Exception(ex);
        }
        catch (UncheckedExecutionException ex) {
            throw new Exception(ex);
        }
        catch (ExecutionError ex) {
            throw new Exception(ex);
        }
        return items;
    }

    @Override
    public Iterable<V> getAll() throws Exception {
        Iterable<K> allKeys = this.getAllKeys();
        return this.get((K)allKeys).values();
    }

    @Override
    public V get(K key) throws Exception {
        Object toReturn = null;
        try {
            toReturn = this.proxied.get(key);
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            throw new Exception(ex);
        }
        catch (UncheckedExecutionException ex) {
            throw new Exception(ex);
        }
        catch (ExecutionError ex) {
            throw new Exception(ex);
        }
        return (V)toReturn;
    }

    @Override
    public void refresh(K key) {
        this.proxied.refresh(key);
    }

    @Override
    public void invalidateAll() {
        this.proxied.invalidateAll();
    }

    @Override
    public void invalidate(Iterable<? extends K> keys) {
        this.proxied.invalidateAll(keys);
    }

    @Override
    public void invalidate(K key) {
        this.proxied.invalidate(key);
    }

    @Override
    public long size() {
        return this.proxied.size();
    }

    @Override
    public V get(K key, Callable<? extends V> callable) throws Exception {
        Object toReturn = null;
        try {
            toReturn = this.proxied.get(key, callable);
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            throw new Exception(ex);
        }
        catch (UncheckedExecutionException ex) {
            throw new Exception(ex);
        }
        catch (ExecutionError ex) {
            throw new Exception(ex);
        }
        return (V)toReturn;
    }

    @Override
    public boolean isEmpty() {
        return this.proxied.size() == 0L;
    }
}

