/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.publishing;

import java.io.Writer;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.api.PublishingOptions;
import org.eclipse.osee.define.rest.publishing.MSWordTemplatePublisher;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.PageOrientation;
import org.eclipse.osee.framework.core.util.WordMLWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class MSWordSpecifiedTemplatePublisher
extends MSWordTemplatePublisher {
    public MSWordSpecifiedTemplatePublisher(PublishingOptions publishingOptions, Writer writer, OrcsApi orcsApi, AtsApi atsApi) {
        super(publishingOptions, writer, orcsApi, atsApi);
    }

    @Override
    protected void processContent(ArtifactReadable headArtifact, WordMLWriter wordMl) {
        if (!this.includeEmptyHeaders) {
            LinkedList<ArtifactReadable> artifacts = new LinkedList<ArtifactReadable>();
            artifacts.add(headArtifact);
            this.populateEmptyHeaders(artifacts);
        }
        this.getDataRightsOverride();
        this.setDataRightResponse(headArtifact);
        this.processArtifact(headArtifact, wordMl);
        if (this.publishingOptions.updateParagraphNumbers) {
            this.updateParagraphNumbers();
        }
        this.addErrorLogToWordMl(wordMl);
    }

    @Override
    protected boolean checkIncluded(ArtifactReadable artifact) {
        return super.checkIncluded(artifact) && !this.emptyFolders.contains(artifact);
    }

    @Override
    protected String getArtifactFooter(ArtifactReadable artifact) {
        String orientationStr = null;
        if (artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.PageOrientation)) {
            orientationStr = (String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.PageOrientation, (Object)"Portrait");
        }
        PageOrientation orientation = PageOrientation.fromString(orientationStr);
        String footer = this.response.getContent((ArtifactId)artifact, orientation);
        return footer;
    }
}

