/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.config.JaxAtsConfigObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;

public class TeamDefinition
extends JaxAtsConfigObject
implements IAtsTeamDefinition {
    @JsonSerialize(using=ToStringSerializer.class)
    Long parentId;
    Set<Long> ais = new HashSet<Long>();
    Set<Long> versions = new HashSet<Long>();
    Set<Long> children = new HashSet<Long>();
    boolean hasWorkPackages = false;

    public TeamDefinition() {
    }

    public TeamDefinition(ArtifactToken artifact, AtsApi atsApi) {
        super(artifact.getId(), artifact.getName());
        this.setStoreObject(artifact);
        this.setAtsApi(atsApi);
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Set<Long> getAis() {
        return this.ais;
    }

    public void setAis(Collection<Long> ais) {
        this.ais.addAll(ais);
    }

    public Set<Long> getVersions() {
        return this.versions;
    }

    public void setVersions(Collection<Long> versions) {
        this.versions.addAll(versions);
    }

    public Set<Long> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<Long> children) {
        this.children.addAll(children);
    }

    public void addChild(TeamDefinition child) {
        this.children.add(child.getId());
    }

    public void addVersion(Long version) {
        this.versions.add(version);
    }

    public void addAi(Long aiId) {
        this.ais.add(aiId);
    }

    @Override
    public ArtifactTypeToken getArtifactType() {
        return AtsArtifactTypes.TeamDefinition;
    }

    @Override
    @JsonIgnore
    public Collection<ActionableItem> getActionableItems() {
        LinkedList<ActionableItem> ais = new LinkedList<ActionableItem>();
        for (Long id : this.getAis()) {
            ais.add(this.atsApi.getConfigService().getConfigurations().getIdToAi().get(id));
        }
        return ais;
    }

    @Override
    @JsonIgnore
    public Collection<TeamDefinition> getChildrenTeamDefs() {
        LinkedList<TeamDefinition> teamDefs = new LinkedList<TeamDefinition>();
        for (Long id : this.getChildren()) {
            TeamDefinition teamDef = this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(id);
            teamDefs.add(teamDef);
        }
        return teamDefs;
    }

    public void addAi(ArtifactToken ai) {
        this.ais.add(ai.getId());
    }

    @Override
    public boolean hasWorkPackages() {
        return this.hasWorkPackages;
    }

    public void setHasWorkPackages(boolean hasWorkPackages) {
        this.hasWorkPackages = hasWorkPackages;
    }

    public boolean isHasWorkPackages() {
        return this.hasWorkPackages;
    }
}

