/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.ObjectType;
import org.eclipse.osee.framework.core.enums.SqlTable;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeSideExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.AbstractRelationSqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;

public class RelationTypeSideExistsSqlHandler
extends AbstractRelationSqlHandler<CriteriaRelationTypeSideExists> {
    private String relAlias;
    private String txsAlias;

    @Override
    public void addTables(AbstractSqlWriter writer) {
        super.addTables(writer);
        this.relAlias = writer.addTable(SqlTable.RELATION_TABLE);
        this.txsAlias = writer.addTable(SqlTable.TXS_TABLE, ObjectType.RELATION);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        String side;
        super.addPredicates(writer);
        writer.write(this.relAlias);
        writer.write(".rel_link_type_id = ?");
        writer.addParameter(((CriteriaRelationTypeSideExists)this.criteria).getType());
        List<String> aliases = writer.getAliases(SqlTable.ARTIFACT_TABLE);
        String string = side = ((RelationTypeSide)((CriteriaRelationTypeSideExists)this.criteria).getType()).getSide().isSideA() ? "a" : "b";
        if (!aliases.isEmpty()) {
            writer.writeAndLn();
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write(this.relAlias);
                writer.write(".");
                writer.write(side);
                writer.write("_art_id = ");
                writer.write(artAlias);
                writer.write(".art_id");
                if (index + 1 < aSize) {
                    writer.writeAndLn();
                }
                ++index;
            }
        }
        writer.writeAndLn();
        writer.write(this.relAlias);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias);
        writer.write(".gamma_id");
        writer.writeAndLn();
        writer.writeTxBranchFilter(this.txsAlias);
    }
}

