/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import org.eclipse.osee.framework.core.enums.SqlTable;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaMainTableField;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public abstract class MainTableFieldSqlHandler
extends SqlHandler<CriteriaMainTableField> {
    private CriteriaMainTableField criteria;
    private String mainAlias;
    private String jIdAlias;
    private final SqlTable table;
    private final String column;
    private final SqlHandlerPriority priority;
    private Collection<? extends Id> values;

    public MainTableFieldSqlHandler(SqlTable table, String column, SqlHandlerPriority priority) {
        this.table = table;
        this.column = column;
        this.priority = priority;
    }

    @Override
    public void setData(CriteriaMainTableField criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.mainAlias = writer.getMainTableAlias(this.table);
        this.values = this.criteria.getValues();
        if (this.values.size() > 1) {
            this.jIdAlias = writer.addTable(SqlTable.OSEE_JOIN_ID_TABLE);
        }
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        if (this.values.size() > 1) {
            if (this.values.contains(null)) {
                throw new OseeArgumentException("cannot specify null id as part of a multiple value search", new Object[0]);
            }
            IdJoinQuery joinQuery = writer.writeJoin(this.values);
            writer.writeEquals(this.mainAlias, this.column, this.jIdAlias, "id");
            writer.write(" AND ");
            writer.writeEqualsParameter(this.jIdAlias, "query_id", joinQuery.getQueryId());
        } else {
            Id value = this.values.iterator().next();
            if (value == null) {
                writer.write("%s.%s is null", this.mainAlias, this.column);
            } else {
                writer.writeEqualsParameter(this.mainAlias, this.column, value);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority.ordinal();
    }
}

