/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.framework.core.enums.SqlTable;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranchAncestorOf;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class BranchAncestorOfSqlHandler
extends SqlHandler<CriteriaBranchAncestorOf> {
    private CriteriaBranchAncestorOf criteria;
    private String cteAlias;
    private String brAlias;

    @Override
    public void setData(CriteriaBranchAncestorOf criteria) {
        this.criteria = criteria;
    }

    @Override
    public void writeCommonTableExpression(AbstractSqlWriter writer) {
        this.cteAlias = writer.startRecursiveCommonTableExpression("anstrof", "(parent_id, branch_level)");
        writer.write("SELECT anch_br1.parent_branch_id, 0 as branch_level FROM osee_branch anch_br1\n   WHERE ");
        writer.writeEqualsParameter("anch_br1", "branch_id", this.criteria.getChild());
        writer.writeCteRecursiveUnion();
        writer.write(" SELECT parent_branch_id, branch_level - 1 FROM " + this.cteAlias);
        writer.write(", osee_branch br WHERE br.branch_id = parent_id");
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        writer.addTable(this.cteAlias);
        this.brAlias = writer.getMainTableAlias(SqlTable.BRANCH_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writeEquals(this.cteAlias, "parent_id", this.brAlias, "branch_id");
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.BRANCH_ANCESTOR_OF.ordinal();
    }
}

