/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import org.eclipse.osee.framework.core.enums.SqlTable;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactGuids;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.CharJoinQuery;

public class ArtifactGuidSqlHandler
extends SqlHandler<CriteriaArtifactGuids> {
    private CriteriaArtifactGuids criteria;
    private String jguidAlias;
    private String cteAlias;
    private String artAlias;
    private String txsAlias;

    @Override
    public void writeCommonTableExpression(AbstractSqlWriter writer) {
        if (OptionsUtil.isHistorical((Options)writer.getOptions())) {
            this.cteAlias = writer.startCommonTableExpression("artMax");
            writer.write("SELECT max(txs.transaction_id) as transaction_id, art.art_id as art_id\n FROM ");
            Collection ids = this.criteria.getIds();
            if (ids.size() > 1) {
                writer.write("osee_join_char_id jid, ");
            }
            writer.write("osee_artifact art, osee_txs txs\n WHERE ");
            if (ids.size() > 1) {
                CharJoinQuery joinQuery = writer.writeCharJoin(ids);
                writer.writeEqualsParameterAnd("jid", "query_id", joinQuery.getQueryId());
                writer.writeEqualsAnd("jid", "id", "art", "guid");
            } else {
                writer.writeEqualsParameterAnd("art", "guid", ids.iterator().next());
            }
            writer.writeEqualsAnd("art", "txs", "gamma_id");
            writer.writeTxBranchFilter("txs", true);
            writer.write("\n GROUP BY art.art_id");
        }
    }

    @Override
    public void setData(CriteriaArtifactGuids criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.cteAlias == null) {
            if (this.criteria.getIds().size() > 1) {
                this.jguidAlias = writer.addTable(SqlTable.OSEE_JOIN_CHAR_ID_TABLE);
            }
        } else {
            writer.addTable(this.cteAlias);
        }
        this.artAlias = writer.getMainTableAlias(SqlTable.ARTIFACT_TABLE);
        this.txsAlias = writer.getMainTableAlias(SqlTable.TXS_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        Collection ids = this.criteria.getIds();
        if (this.cteAlias == null) {
            if (ids.size() > 1) {
                CharJoinQuery joinQuery = writer.writeCharJoin(ids);
                writer.writeEqualsParameterAnd(this.jguidAlias, "query_id", joinQuery.getQueryId());
                writer.writeEquals(this.jguidAlias, "id", this.artAlias, "guid");
            } else {
                writer.writeEqualsParameter(this.artAlias, "guid", ids.iterator().next());
            }
        } else {
            writer.writeEqualsAnd(this.cteAlias, this.artAlias, "art_id");
            writer.writeEquals(this.cteAlias, this.txsAlias, "transaction_id");
        }
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_GUID.ordinal();
    }
}

