/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.KeyValueStore;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerAdapter;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeKeywords;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.ArtifactReadableImpl;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.search.QueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.ApplicabilityDsQueryImpl;
import org.eclipse.osee.orcs.db.internal.search.engines.Attribute;
import org.eclipse.osee.orcs.db.internal.search.engines.TupleQueryImpl;
import org.eclipse.osee.orcs.db.internal.sql.SelectiveArtifactSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;

public class QueryEngineImpl
implements QueryEngine {
    private final QueryCallableFactory artifactQueryEngineFactory;
    private final QuerySqlContextFactory branchSqlContextFactory;
    private final QuerySqlContextFactory txSqlContextFactory;
    private final QueryCallableFactory allQueryEngineFactory;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory sqlJoinFactory;
    private final SqlObjectLoader sqlObjectLoader;
    private final KeyValueStore keyValue;
    private final SqlHandlerFactory handlerFactory;
    private final OrcsTokenService tokenService;
    private final IResourceManager resourceManager;

    public QueryEngineImpl(QueryCallableFactory artifactQueryEngineFactory, QuerySqlContextFactory branchSqlContextFactory, QuerySqlContextFactory txSqlContextFactory, QueryCallableFactory allQueryEngineFactory, JdbcClient jdbcClient, SqlJoinFactory sqlJoinFactory, SqlHandlerFactory handlerFactory, SqlObjectLoader sqlObjectLoader, OrcsTokenService tokenService, KeyValueStore keyValue, IResourceManager resourceManager) {
        this.artifactQueryEngineFactory = artifactQueryEngineFactory;
        this.branchSqlContextFactory = branchSqlContextFactory;
        this.txSqlContextFactory = txSqlContextFactory;
        this.allQueryEngineFactory = allQueryEngineFactory;
        this.jdbcClient = jdbcClient;
        this.sqlJoinFactory = sqlJoinFactory;
        this.sqlObjectLoader = sqlObjectLoader;
        this.tokenService = tokenService;
        this.keyValue = keyValue;
        this.handlerFactory = handlerFactory;
        this.resourceManager = resourceManager;
    }

    public int getArtifactCount(QueryData queryData) {
        if (this.isPostProcessRequired(queryData)) {
            return this.artifactQueryEngineFactory.getArtifactCount(queryData);
        }
        QueryData rootQueryData = queryData.getRootQueryData();
        return new SelectiveArtifactSqlWriter(this.sqlJoinFactory, this.jdbcClient, rootQueryData).getCount(this.handlerFactory);
    }

    private boolean isPostProcessRequired(QueryData queryData) {
        return queryData.hasCriteriaType(CriteriaAttributeKeywords.class);
    }

    public void runArtifactQuery(QueryData queryData, LoadDataHandler handler) throws Exception {
        this.artifactQueryEngineFactory.createQuery(null, queryData, handler).call();
        queryData.reset();
    }

    public int getBranchCount(QueryData queryData) {
        return this.getCount(this.branchSqlContextFactory, queryData);
    }

    public void runBranchQuery(QueryData queryData, List<? super Branch> branches) {
        QuerySqlContext queryContext = this.branchSqlContextFactory.createQueryContext(null, queryData, QueryType.SELECT);
        this.sqlObjectLoader.loadBranches(branches, queryContext);
        queryData.reset();
    }

    public int getTxCount(QueryData queryData) {
        return this.getCount(this.txSqlContextFactory, queryData);
    }

    private int getCount(QuerySqlContextFactory sqlContextFactory, QueryData queryData) {
        QuerySqlContext queryContext = sqlContextFactory.createQueryContext(null, queryData, QueryType.COUNT);
        int count = this.sqlObjectLoader.getCount(queryContext);
        queryData.reset();
        return count;
    }

    public void runTxQuery(QueryData queryData, List<? super TransactionReadable> txs) {
        QuerySqlContext queryContext = this.txSqlContextFactory.createQueryContext(null, queryData, QueryType.SELECT);
        this.sqlObjectLoader.loadTransactions(txs, queryContext);
        queryData.reset();
    }

    public CancellableCallable<Integer> createQuery(OrcsSession session, QueryData queryData, LoadDataHandler handler) {
        return this.allQueryEngineFactory.createQuery(session, queryData, handler);
    }

    public TupleQuery createTupleQuery() {
        return new TupleQueryImpl(this.jdbcClient, this.sqlJoinFactory, this.keyValue, this.tokenService);
    }

    public List<ArtifactToken> asArtifactTokens(QueryData queryData) {
        ArrayList<ArtifactToken> tokens = new ArrayList<ArtifactToken>(100);
        this.selectiveArtifactLoad(queryData, stmt -> {
            boolean bl = tokens.add(ArtifactToken.valueOf((long)stmt.getLong("art_id"), (String)stmt.getString("value"), (BranchId)queryData.getBranch(), (ArtifactTypeToken)this.tokenService.getArtifactTypeOrCreate(Long.valueOf(stmt.getLong("art_type_id")))));
        });
        return tokens;
    }

    public Map<ArtifactId, ArtifactReadable> asArtifactMap(QueryData queryData, QueryFactory queryFactory) {
        HashMap<ArtifactId, ArtifactReadable> artifacts = new HashMap<ArtifactId, ArtifactReadable>(500);
        this.loadArtifactsInto(queryData, queryFactory, a -> {
            ArtifactReadable artifactReadable = artifacts.put((ArtifactId)a, (ArtifactReadable)a);
        });
        return artifacts;
    }

    public List<ArtifactReadable> asArtifacts(QueryData queryData, QueryFactory queryFactory) {
        ArrayList<ArtifactReadable> artifacts = new ArrayList<ArtifactReadable>(500);
        this.loadArtifactsInto(queryData, queryFactory, a -> {
            boolean bl = artifacts.add((ArtifactReadable)a);
        });
        return artifacts;
    }

    private void loadArtifactsInto(QueryData queryData, QueryFactory queryFactory, Consumer<ArtifactReadable> artifactConsumer) {
        HashMap artifactMap = new HashMap(500);
        Consumer<JdbcStatement> jdbcConsumer = stmt -> {
            Long artId = stmt.getLong("art_id");
            ArtifactReadableImpl artifact = (ArtifactReadableImpl)artifactMap.get(ArtifactId.valueOf((Long)artId));
            if (artifact == null) {
                artifact = this.createArtifact((JdbcStatement)stmt, artId, stmt.getLong("art_type_id"), queryData, queryFactory);
                artifactMap.put(artifact, artifact);
                if (stmt.getLong("top") == 1L) {
                    artifactConsumer.accept((ArtifactReadable)artifact);
                }
            }
            Long typeId = stmt.getLong("type_id");
            Long otherArtId = stmt.getLong("other_art_id");
            String value = stmt.getString("value");
            String uri = stmt.getString("uri");
            if (otherArtId == 0L) {
                AttributeTypeGeneric attributeType = this.tokenService.getAttributeTypeOrCreate(typeId);
                Attribute attribute = new Attribute(stmt.getLong("attr_id"), attributeType, value, uri, this.resourceManager);
                artifact.putAttributeValue(attributeType, attribute);
            } else {
                Long otherArtType = stmt.getLong("other_art_type_id");
                RelationSide side = value.equals("A") ? RelationSide.SIDE_A : RelationSide.SIDE_B;
                ArtifactReadableImpl otherArtifact = (ArtifactReadableImpl)artifactMap.get(ArtifactId.valueOf((Long)otherArtId));
                if (otherArtifact == null) {
                    otherArtifact = this.createArtifact((JdbcStatement)stmt, otherArtId, otherArtType, queryData, queryFactory);
                    artifactMap.put(otherArtifact, otherArtifact);
                }
                artifact.putRelation(this.tokenService.getRelationTypeOrCreate(typeId), side, (ArtifactReadable)otherArtifact);
            }
        };
        this.selectiveArtifactLoad(queryData, jdbcConsumer);
    }

    private ArtifactReadableImpl createArtifact(JdbcStatement stmt, Long artId, Long artifactTypeId, QueryData queryData, QueryFactory queryFactory) {
        TransactionId txId = TransactionId.valueOf((Long)stmt.getLong("transaction_id"));
        ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
        ArtifactTypeToken artifactType = this.tokenService.getArtifactTypeOrCreate(artifactTypeId);
        ApplicabilityId applic = ApplicabilityId.valueOf((Long)stmt.getLong("app_id"));
        return new ArtifactReadableImpl(artId, artifactType, BranchToken.create((BranchId)queryData.getBranch(), (String)"unknown"), queryData.getView(), applic, txId, modType, queryFactory);
    }

    public List<Map<String, Object>> asArtifactMaps(QueryData queryData) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(500);
        HashCollection attributes = new HashCollection();
        Long[] artifactId = new Long[]{Id.SENTINEL};
        Long[] applicability = new Long[]{Id.SENTINEL};
        ArtifactTypeToken[] artifactType = new ArtifactTypeToken[]{ArtifactTypeToken.SENTINEL};
        Consumer<JdbcStatement> consumer = stmt -> {
            Long newArtId = stmt.getLong("art_id");
            if (artifactId[0].equals(Id.SENTINEL)) {
                longArray[0] = newArtId;
                longArray2[0] = stmt.getLong("app_id");
                artifactTypeTokenArray[0] = this.tokenService.getArtifactTypeOrCreate(Long.valueOf(stmt.getLong("art_type_id")));
            } else if (!artifactId[0].equals(newArtId)) {
                maps.add(this.createFieldMap(artifactType[0], artifactId[0], applicability[0], (HashCollection<AttributeTypeToken, Object>)attributes));
                attributes.clear();
                longArray[0] = newArtId;
                longArray2[0] = stmt.getLong("app_id");
                artifactTypeTokenArray[0] = this.tokenService.getArtifactTypeOrCreate(Long.valueOf(stmt.getLong("art_type_id")));
            }
            attributes.put((Object)this.tokenService.getAttributeTypeOrCreate(Long.valueOf(stmt.getLong("type_id"))), (Object)stmt.getString("value"));
        };
        this.selectiveArtifactLoad(queryData, consumer);
        if (!artifactId[0].equals(Id.SENTINEL)) {
            maps.add(this.createFieldMap(artifactType[0], artifactId[0], applicability[0], (HashCollection<AttributeTypeToken, Object>)attributes));
        }
        return maps;
    }

    private Map<String, Object> createFieldMap(ArtifactTypeToken artifactType, Long artifactId, Long applicability, HashCollection<AttributeTypeToken, Object> attributes) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Name", attributes.getValues((Object)CoreAttributeTypes.Name));
        map.put("Artifact Type", artifactType.getIdString());
        map.put("Artifact Id", artifactId.toString());
        map.put("Applicability Id", applicability.toString());
        ArrayList attributeTypes = new ArrayList(attributes.keySet());
        Collections.sort(attributeTypes);
        for (AttributeTypeToken attributeType : attributeTypes) {
            List attributeValues = (List)attributes.getValues((Object)attributeType);
            if (attributeValues.size() == 1) {
                map.put(attributeType.getName(), attributeValues.get(0));
                continue;
            }
            map.put(attributeType.getName(), attributeValues);
        }
        return map;
    }

    public Map<ArtifactId, ArtifactToken> asArtifactTokenMap(QueryData queryData) {
        HashMap<ArtifactId, ArtifactToken> tokens = new HashMap<ArtifactId, ArtifactToken>(10000);
        Consumer<JdbcStatement> consumer = stmt -> {
            ArtifactToken token = ArtifactToken.valueOf((long)stmt.getLong("art_id"), (String)stmt.getString("value"), (BranchId)queryData.getBranch(), (ArtifactTypeToken)this.tokenService.getArtifactTypeOrCreate(Long.valueOf(stmt.getLong("art_type_id"))));
            tokens.put((ArtifactId)token, token);
        };
        this.selectiveArtifactLoad(queryData, consumer);
        return tokens;
    }

    public List<ArtifactId> asArtifactIds(QueryData queryData) {
        final ArrayList<ArtifactId> ids = new ArrayList<ArtifactId>(100);
        if (this.isPostProcessRequired(queryData)) {
            LoadDataHandlerAdapter handler = new LoadDataHandlerAdapter(){

                public void onData(ArtifactData data) {
                    ids.add(data);
                }
            };
            OptionsUtil.setLoadLevel((Options)queryData.getOptions(), (LoadLevel)LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA);
            try {
                this.runArtifactQuery(queryData, (LoadDataHandler)handler);
                return ids;
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        this.selectiveArtifactLoad(queryData, stmt -> {
            boolean bl = ids.add(ArtifactId.valueOf((Long)stmt.getLong("art_id")));
        });
        return ids;
    }

    private void selectiveArtifactLoad(QueryData queryData, Consumer<JdbcStatement> consumer) {
        QueryData rootQueryData = queryData.getRootQueryData();
        new SelectiveArtifactSqlWriter(this.sqlJoinFactory, this.jdbcClient, rootQueryData).runSql(consumer, this.handlerFactory);
    }

    public ApplicabilityDsQuery createApplicabilityDsQuery() {
        return new ApplicabilityDsQueryImpl(this.jdbcClient, this.sqlJoinFactory);
    }

    public boolean isArchived(BranchId branchId) {
        String SELECT_IS_BRANCH_ARCHIVED = "select archived from osee_branch where branch_id = ?";
        Integer result = (Integer)this.jdbcClient.fetchOrException(Integer.class, () -> new OseeCoreException("Failed to get Branch archived state for %s", new Object[]{branchId}), SELECT_IS_BRANCH_ARCHIVED, new Object[]{branchId});
        return BranchArchivedState.valueOf((int)result).isArchived();
    }
}

