/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.mim.annotations.OseeArtifactAttribute;
import org.eclipse.osee.mim.annotations.OseeArtifactRequiredAttribute;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.NodeViewData;
import org.eclipse.osee.mim.types.PLGenericDBObject;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class NodeView
extends PLGenericDBObject {
    @OseeArtifactRequiredAttribute
    @OseeArtifactAttribute(attributeId=0x1000000000000070L)
    private String Name;
    @OseeArtifactAttribute(attributeId=1152921504606847090L)
    private String Description;
    private String label = "";
    private NodeViewData data;

    public NodeView(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public NodeView(InterfaceNode node) {
        this(node.getId(), node.getName(), node.getDescription(), node.getApplicability());
    }

    public NodeView(ArtifactReadable art) {
        super(art);
        this.setData(new NodeViewData(art));
    }

    public NodeView(Long id, String name, String description, ApplicabilityToken applicability) {
        this(id, name);
        this.setLabel(name);
        this.setData(new NodeViewData(id, name));
        this.setApplicability(applicability);
        this.setDescription(description);
    }

    public NodeView(Long id, String name) {
        super(id, name);
    }

    public NodeView() {
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @JsonIgnore
    public String getName() {
        return super.getName();
    }

    public void setName(String name) {
        super.setName(name);
        this.setLabel(name);
    }

    @JsonIgnore
    public String getDescription() {
        return this.data.getDescription();
    }

    public void setDescription(String description) {
        this.data.setDescription(description);
    }

    public NodeViewData getData() {
        return this.data;
    }

    public void setData(NodeViewData data) {
        this.data = data;
    }

    @JsonIgnore
    public String getbgColor() {
        return this.data.getbgColor();
    }

    @JsonIgnore
    public void setbgColor(String color) {
        this.data.setbgColor(color);
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.data.setApplicability(applicability);
    }
}

