/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class BranchDataFactory {
    private final QueryFactory queryFactory;

    public BranchDataFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public CreateBranchData createBaselineBranchData(BranchToken branch, ArtifactId author, BranchToken parent, ArtifactId associatedArtifact) {
        return this.createBranchData(branch, author, parent, associatedArtifact, BranchType.BASELINE);
    }

    public CreateBranchData createWorkingBranchData(BranchToken branch, ArtifactId author, BranchToken parent, ArtifactId associatedArtifact) {
        return this.createBranchData(branch, author, parent, associatedArtifact, BranchType.WORKING);
    }

    private CreateBranchData createBranchData(BranchToken branch, ArtifactId author, BranchToken parent, ArtifactId associatedArtifact, BranchType branchType) {
        TransactionQuery txQuery = this.queryFactory.transactionQuery();
        TransactionToken fromTx = (TransactionToken)((TransactionQuery)txQuery.andIsHead((BranchId)parent)).getTokens().getExactlyOne();
        String creationComment = String.format("New Branch from %s (%s)", parent.getName(), fromTx.getIdString());
        return this.createBranchData(branch, (BranchId)parent, branchType, creationComment, fromTx, author, associatedArtifact, false);
    }

    public CreateBranchData createCopyTxBranchData(BranchToken branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact) {
        return this.createBranchData(branch, author, fromTransaction, associatedArtifact, BranchType.WORKING, "copied");
    }

    public CreateBranchData createPortBranchData(BranchToken branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact) {
        return this.createBranchData(branch, author, fromTransaction, associatedArtifact, BranchType.PORT, "ported");
    }

    private CreateBranchData createBranchData(BranchToken branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact, BranchType branchType, String verb) {
        TransactionQuery txQuery = this.queryFactory.transactionQuery();
        BranchQuery branchQuery = this.queryFactory.branchQuery();
        TransactionToken fromTx = (TransactionToken)((TransactionQuery)txQuery.andTxId(fromTransaction)).getTokens().getExactlyOne();
        BranchToken parent = (BranchToken)((BranchQuery)branchQuery.andId(fromTx.getBranch())).getResults().getExactlyOne();
        String creationComment = String.format("Transaction %d %s from %s to create Branch %s", fromTransaction.getId(), verb, parent.getName(), branch.getName());
        return this.createBranchData(branch, (BranchId)parent, branchType, creationComment, fromTx, author, associatedArtifact, true);
    }

    private CreateBranchData createBranchData(BranchToken branch, BranchId parent, BranchType branchType, String creationComment, TransactionToken sysRootHeadTx, ArtifactId author, ArtifactId associatedArtifact, boolean bCopyTx) {
        CreateBranchData createData = new CreateBranchData(branch);
        createData.setName(branch.getName());
        createData.setBranchType(branchType);
        createData.setCreationComment(creationComment);
        createData.setFromTransaction(sysRootHeadTx);
        createData.setAuthor(author);
        createData.setAssociatedArtifact(associatedArtifact);
        createData.setTxCopyBranchType(bCopyTx);
        createData.setParentBranch(parent);
        return createData;
    }
}

