/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.osee.cache.admin.CacheDataLoader;
import org.eclipse.osee.cache.admin.CacheKeysLoader;
import org.eclipse.osee.framework.core.server.internal.session.ISessionCollector;
import org.eclipse.osee.framework.core.server.internal.session.ISessionQuery;
import org.eclipse.osee.framework.core.server.internal.session.Session;
import org.eclipse.osee.framework.core.server.internal.session.SessionFactory;
import org.eclipse.osee.framework.core.server.internal.session.WriteDataAccessor;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcTransaction;

public final class DatabaseSessionAccessor
implements CacheDataLoader<String, Session>,
CacheKeysLoader<String>,
WriteDataAccessor<Session> {
    private static final String INSERT_SESSION = "INSERT INTO osee_session (session_id, user_id, client_machine_name, client_address, client_port, client_version, created_on) VALUES (?,?,?,?,?,?,?)";
    private static final String DELETE_SESSION = "DELETE FROM osee_session WHERE session_id = ?";
    private final SessionFactory sessionFactory;
    private final ISessionQuery sessionQuery;
    private final JdbcClient jdbcClient;

    public DatabaseSessionAccessor(SessionFactory sessionFactory, ISessionQuery sessionQuery, JdbcClient jdbcClient) {
        this.sessionFactory = sessionFactory;
        this.sessionQuery = sessionQuery;
        this.jdbcClient = jdbcClient;
    }

    private SessionFactory getFactory() {
        return this.sessionFactory;
    }

    private JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    private ISessionQuery getSessionQuery() {
        return this.sessionQuery;
    }

    private void executeTx(SessionTxType op, Iterable<Session> sessions) {
        JdbcClient jdbcClient2 = this.getJdbcClient();
        SessionTx transaction = new SessionTx(jdbcClient2, op, sessions);
        this.jdbcClient.runTransaction((JdbcTransaction)transaction);
    }

    @Override
    public void create(Iterable<Session> sessions) {
        this.executeTx(SessionTxType.CREATE, sessions);
    }

    @Override
    public void delete(Iterable<Session> sessions) {
        this.executeTx(SessionTxType.DELETE, sessions);
    }

    public Map<String, Session> load(Iterable<? extends String> sessionIds) {
        final LinkedHashMap<String, Session> sessions = new LinkedHashMap<String, Session>();
        ISessionCollector collector = new ISessionCollector(){

            @Override
            public void collect(String guid, String userId, Date creationDate, String clientVersion, String clientMachineName, String clientAddress, int clientPort) {
                Session session = DatabaseSessionAccessor.this.getFactory().createLoadedSession(guid, userId, creationDate, clientVersion, clientMachineName, clientAddress, clientPort);
                sessions.put(guid, session);
            }
        };
        this.getSessionQuery().selectSessionById(collector, sessionIds.iterator().next());
        return sessions;
    }

    public Session load(String sessionId) {
        Map<String, Session> loaded = this.load(Collections.singleton(sessionId));
        Session toReturn = null;
        if (!loaded.values().isEmpty()) {
            toReturn = loaded.values().iterator().next();
        }
        return toReturn;
    }

    public Session reload(String key, Session oldValue) {
        return this.load(key);
    }

    public Iterable<? extends String> getAllKeys() {
        final LinkedHashSet ids = new LinkedHashSet();
        ISessionCollector idCollector = new ISessionCollector(){

            @Override
            public void collect(String guid, String userId, Date creationDate, String clientVersion, String clientMachineName, String clientAddress, int clientPort) {
                ids.add(guid);
            }
        };
        this.getSessionQuery().selectAllServerManagedSessions(idCollector);
        return ids;
    }

    private static final class SessionTx
    extends JdbcTransaction {
        private final JdbcClient jdbcClient;
        private final SessionTxType txType;
        private final Iterable<Session> sessions;

        public SessionTx(JdbcClient jdbcClient, SessionTxType txType, Iterable<Session> sessions) {
            this.jdbcClient = jdbcClient;
            this.txType = txType;
            this.sessions = sessions;
        }

        public void handleTxWork(JdbcConnection connection) {
            switch (this.txType) {
                case CREATE: {
                    this.create(connection);
                    break;
                }
                case DELETE: {
                    this.delete(connection);
                    break;
                }
            }
        }

        private void create(JdbcConnection connection) {
            ArrayList<Object[]> insertData = new ArrayList<Object[]>();
            for (Session session : this.sessions) {
                insertData.add(this.toInsert(session));
            }
            if (!insertData.isEmpty()) {
                this.jdbcClient.runBatchUpdate(connection, DatabaseSessionAccessor.INSERT_SESSION, insertData);
            }
        }

        private void delete(JdbcConnection connection) {
            ArrayList<Object[]> deleteData = new ArrayList<Object[]>();
            for (Session session : this.sessions) {
                deleteData.add(this.toDelete(session));
            }
            if (!deleteData.isEmpty()) {
                this.jdbcClient.runBatchUpdate(connection, DatabaseSessionAccessor.DELETE_SESSION, deleteData);
            }
        }

        private Object[] toInsert(Session session) {
            return new Object[]{session.getGuid(), session.getUserId(), session.getClientMachineName(), session.getClientAddress(), session.getClientPort(), session.getClientVersion(), session.getCreationDate()};
        }

        private Object[] toDelete(Session session) {
            return new Object[]{session.getGuid()};
        }
    }

    private static enum SessionTxType {
        CREATE,
        DELETE;

    }
}

