/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.util.Map;
import java.util.Properties;
import org.eclipse.osee.jdbc.JdbcConstants;
import org.eclipse.osee.jdbc.JdbcPoolConfig;
import org.eclipse.osee.jdbc.internal.JdbcUtil;

public class JdbcClientConfig {
    private String dbDriver;
    private String dbUri;
    private boolean production;
    private boolean dbAppendPropsToUri;
    private final Properties dbProps = new Properties();
    private final JdbcPoolConfig poolConfig = new JdbcPoolConfig();

    JdbcClientConfig() {
        this.reset();
    }

    public boolean isProduction() {
        return this.production;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbUri() {
        return this.dbUri;
    }

    public boolean isDbAppendPropsToUri() {
        return this.dbAppendPropsToUri;
    }

    public String getDbUsername() {
        return (String)this.dbProps.get("user");
    }

    public String getDbPassword() {
        return (String)this.dbProps.get("password");
    }

    public Properties getDbProps() {
        Properties unmodifiable = new Properties();
        unmodifiable.putAll((Map<?, ?>)this.dbProps);
        return unmodifiable;
    }

    public JdbcPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    void setProduction(boolean production) {
        this.production = production;
    }

    void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    void setDbUri(String dbUri) {
        this.dbUri = dbUri;
    }

    void setDbAppendPropsToUri(boolean dbAppendPropsToUri) {
        this.dbAppendPropsToUri = dbAppendPropsToUri;
    }

    void setDbUsername(String value) {
        this.addDbParam("user", value);
    }

    void setDbPassword(String value) {
        this.addDbParam("password", value);
    }

    void addDbParam(String key, String value) {
        if (value == null) {
            this.removeDbParam(key);
        } else {
            this.dbProps.put(key, value);
        }
    }

    void removeDbParam(String key) {
        this.dbProps.remove(key);
    }

    private void reset() {
        this.dbProps.clear();
        this.setProduction(false);
        this.setDbDriver(JdbcConstants.DEFAULT_JDBC__CONNECTION_DRIVER);
        this.setDbUri(JdbcConstants.DEFAULT_JDBC__CONNECTION_URI);
        this.setDbUsername(JdbcConstants.DEFAULT_JDBC__CONNECTION_USERNAME);
        this.setDbPassword("");
        this.setDbAppendPropsToUri(false);
        this.getPoolConfig().reset();
    }

    void readProperties(Map<String, Object> src) {
        this.setProduction(JdbcUtil.getBoolean(src, JdbcConstants.JDBC__IS_PRODUCTION_DB, false));
        this.setDbDriver(JdbcUtil.get(src, JdbcConstants.JDBC__CONNECTION_DRIVER, JdbcConstants.DEFAULT_JDBC__CONNECTION_DRIVER));
        this.setDbUri(JdbcUtil.get(src, JdbcConstants.JDBC__CONNECTION_URI, JdbcConstants.DEFAULT_JDBC__CONNECTION_URI));
        this.setDbUsername(JdbcUtil.get(src, JdbcConstants.JDBC__CONNECTION_USERNAME, JdbcConstants.DEFAULT_JDBC__CONNECTION_USERNAME));
        this.setDbPassword(JdbcUtil.get(src, JdbcConstants.JDBC__CONNECTION_PASSWORD, ""));
        this.setDbAppendPropsToUri(JdbcUtil.getBoolean(src, JdbcConstants.JDBC__CONNECTION_APPEND_PROPS_TO_URI, false));
        for (Map.Entry<String, Object> entry : src.entrySet()) {
            String key = entry.getKey();
            if (!JdbcUtil.isValidExtraParam(key)) continue;
            Object value = entry.getValue();
            if (value != null) {
                this.addDbParam(key, String.valueOf(value));
                continue;
            }
            this.removeDbParam(key);
        }
        this.getPoolConfig().readProperties(src);
    }

    protected JdbcClientConfig copy() {
        JdbcClientConfig data = new JdbcClientConfig();
        data.production = this.production;
        data.dbDriver = this.dbDriver;
        data.dbUri = this.dbUri;
        data.dbAppendPropsToUri = this.dbAppendPropsToUri;
        data.poolConfig.copy(this.poolConfig);
        data.dbProps.clear();
        data.dbProps.putAll((Map<?, ?>)this.dbProps);
        return data;
    }

    protected void copy(JdbcClientConfig other) {
        this.production = other.production;
        this.dbDriver = other.dbDriver;
        this.dbUri = other.dbUri;
        this.dbAppendPropsToUri = other.dbAppendPropsToUri;
        this.poolConfig.copy(other.poolConfig);
        this.dbProps.clear();
        this.dbProps.putAll((Map<?, ?>)other.dbProps);
    }

    public String toString() {
        return "JdbcClientConfig [dbDriver=" + this.dbDriver + ", dbUri=" + this.dbUri + ", production=" + this.production + ", dbAppendPropsToUri=" + this.dbAppendPropsToUri + ", dbProps=" + this.dbProps + ", poolConfig=" + this.poolConfig + "]";
    }
}

