/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.type;

import org.eclipse.osee.framework.core.enums.StorageState;
import org.eclipse.osee.framework.core.model.OseeEnumEntry;
import org.eclipse.osee.framework.core.model.cache.AbstractOseeCache;
import org.eclipse.osee.framework.core.model.cache.IOseeCache;
import org.eclipse.osee.framework.core.model.cache.IOseeTypeFactory;
import org.eclipse.osee.framework.core.model.cache.OseeEnumTypeCache;
import org.eclipse.osee.framework.core.model.type.OseeEnumType;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class OseeEnumTypeFactory
implements IOseeTypeFactory {
    public OseeEnumType createEnumType(Long guid, String name) {
        Conditions.checkNotNullOrEmpty((String)name, (String)"osee enum type name");
        return new OseeEnumType(guid, name);
    }

    public OseeEnumEntry createEnumEntry(String name, int ordinal, String description) {
        Conditions.checkNotNullOrEmpty((String)name, (String)"osee enum entry name");
        Conditions.checkExpressionFailOnTrue((ordinal < 0 ? 1 : 0) != 0, (String)"ordinal must be greater than or equal to zero", (Object[])new Object[0]);
        return new OseeEnumEntry(name, ordinal, description);
    }

    public OseeEnumType createOrUpdate(IOseeCache<OseeEnumType> cache, long enumTypeId, StorageState storageState, Long guid, String enumTypeName) {
        Conditions.checkNotNull(cache, (String)"OseeEnumTypeCache");
        OseeEnumType oseeEnumType = cache.getById(enumTypeId);
        if (oseeEnumType == null) {
            oseeEnumType = this.createEnumType(guid, enumTypeName);
            oseeEnumType.setStorageState(storageState);
            cache.cache(oseeEnumType);
        } else {
            oseeEnumType.setName(enumTypeName);
        }
        return oseeEnumType;
    }

    public OseeEnumType createOrUpdate(OseeEnumTypeCache cache, Long guid, String enumTypeName) {
        Conditions.checkNotNull((Object)cache, (String)"OseeEnumTypeCache");
        OseeEnumType oseeEnumType = (OseeEnumType)cache.getByGuid(guid);
        if (oseeEnumType == null) {
            oseeEnumType = this.createEnumType(guid, enumTypeName);
            cache.cache(oseeEnumType);
        } else {
            oseeEnumType.setName(enumTypeName);
        }
        return oseeEnumType;
    }

    public OseeEnumEntry createOrUpdate(IOseeCache<OseeEnumType> cache, Long enumTypeGuid, String enumEntryName, int ordinal, String enumEntryDescription) {
        Conditions.checkNotNull(cache, (String)"OseeEnumTypeCache");
        OseeEnumType oseeEnumType = (OseeEnumType)((AbstractOseeCache)cache).getByGuid(enumTypeGuid);
        OseeEnumEntry enumEntry = oseeEnumType.getEntryByName(enumEntryName);
        if (enumEntry == null) {
            enumEntry = this.createEnumEntry(enumEntryName, ordinal, enumEntryDescription);
            oseeEnumType.addEntry(enumEntry);
        } else {
            enumEntry.setName(enumEntryName);
            enumEntry.setOrdinal(ordinal);
            enumEntry.setDescription(enumEntryDescription);
        }
        return enumEntry;
    }
}

