/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.authentication.ldap.core.internal;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.eclipse.osee.logger.Log;

public class LDAPConnector {
    public static final String DEFAULT_ACCOUNT_SEARCH_FILTER = "(&(objectCategory=person)(sAMAccountName=%s))";
    public static final String DEFAULT_ACCOUNT_FIELD = "sAMAccountName";
    private final Log logger;
    private final String searchBase;
    private final Hashtable<String, String> env;
    private final String accountSearchFilter;
    private final String accountField;

    public LDAPConnector(Log logger, Hashtable<String, String> env, String searchBase) {
        this(logger, env, searchBase, DEFAULT_ACCOUNT_SEARCH_FILTER, DEFAULT_ACCOUNT_FIELD);
    }

    public LDAPConnector(Log logger, Hashtable<String, String> env, String searchBase, String accountSearchFilter, String accountField) {
        this.logger = logger;
        this.env = env;
        this.searchBase = searchBase;
        this.accountSearchFilter = accountSearchFilter;
        this.accountField = accountField;
    }

    public String findAccountNameForUser(String username) throws NamingException {
        String toReturn;
        block11: {
            toReturn = null;
            String searchFilter = String.format(this.accountSearchFilter, username);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            InitialLdapContext ldapContext = null;
            try {
                ldapContext = new InitialLdapContext(this.env, null);
                this.logger.info("LDAP connection established", new Object[0]);
                NamingEnumeration<SearchResult> results = ldapContext.search(this.searchBase, searchFilter, searchControls);
                if (results == null) break block11;
                while (results.hasMoreElements()) {
                    SearchResult searchResult = (SearchResult)results.nextElement();
                    Attributes attribs = searchResult.getAttributes();
                    if (attribs.size() > 0) {
                        Attribute attribute = attribs.get(this.accountField);
                        NamingEnumeration<?> allMembers = attribute.getAll();
                        while (allMembers != null && allMembers.hasMoreElements()) {
                            String accountName = (String)allMembers.next();
                            if (!username.equalsIgnoreCase(accountName)) continue;
                            toReturn = accountName;
                            break;
                        }
                    }
                    if (toReturn == null) continue;
                    break;
                }
            }
            finally {
                if (ldapContext != null) {
                    try {
                        ldapContext.close();
                    }
                    catch (NamingException e) {
                        this.logger.info((Throwable)e, "Error closing LDAP context", new Object[0]);
                    }
                }
            }
        }
        return toReturn;
    }

    public boolean isLDAPUSer(String username) {
        boolean result = false;
        try {
            String accountName = this.findAccountNameForUser(username);
            result = accountName != null;
        }
        catch (NamingException ex) {
            this.logger.info((Throwable)ex, "Error authenticating LDAP user [%s]", new Object[]{username});
        }
        return result;
    }
}

