/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.orcsScriptDsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OsBranchType implements Enumerator
{
    WORKING(0, "WORKING", "working"),
    BASELINE(1, "BASELINE", "baseline"),
    MERGE(2, "MERGE", "merge"),
    SYSTEM_ROOT(3, "SYSTEM_ROOT", "system-root"),
    PORT(4, "PORT", "port");

    public static final int WORKING_VALUE = 0;
    public static final int BASELINE_VALUE = 1;
    public static final int MERGE_VALUE = 2;
    public static final int SYSTEM_ROOT_VALUE = 3;
    public static final int PORT_VALUE = 4;
    private static final OsBranchType[] VALUES_ARRAY;
    public static final List<OsBranchType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OsBranchType[]{WORKING, BASELINE, MERGE, SYSTEM_ROOT, PORT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OsBranchType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OsBranchType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OsBranchType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OsBranchType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OsBranchType get(int value) {
        switch (value) {
            case 0: {
                return WORKING;
            }
            case 1: {
                return BASELINE;
            }
            case 2: {
                return MERGE;
            }
            case 3: {
                return SYSTEM_ROOT;
            }
            case 4: {
                return PORT;
            }
        }
        return null;
    }

    private OsBranchType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

