/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.JdbcService;

public interface IAtsStoreService {
    public static final String ART_TYPE_FROM_ID_QUERY = "select art_id, art_type_id from osee_artifact where art_id in (%s)";

    public IAtsChangeSet createAtsChangeSet(String var1, IAtsUser var2);

    public List<IAtsWorkItem> reload(Collection<IAtsWorkItem> var1);

    public boolean isDeleted(IAtsObject var1);

    public boolean isAttributeTypeValid(IAtsObject var1, AttributeTypeToken var2);

    public boolean isAttributeTypeValid(ArtifactId var1, AttributeTypeToken var2);

    public Set<ArtifactTypeToken> getTeamWorkflowArtifactTypes();

    public AttributeTypeToken getAttributeType(String var1);

    public ArtifactTypeToken getArtifactType(ArtifactId var1);

    public ArtifactTypeToken getArtifactType(IAtsObject var1);

    public boolean isDateType(AttributeTypeId var1);

    public boolean isOfType(ArtifactId var1, ArtifactTypeId ... var2);

    public ArtifactTypeToken getArtifactType(Long var1);

    public void executeChangeSet(String var1, IAtsObject var2);

    public void executeChangeSet(String var1, Collection<? extends IAtsObject> var2);

    public Collection<AttributeTypeToken> getAttributeTypes();

    public boolean isChangedInDb(IAtsWorkItem var1);

    public boolean isOfType(IAtsObject var1, ArtifactTypeToken var2);

    public void clearCaches(IAtsWorkItem var1);

    public AttributeTypeToken getAttributeType(Long var1);

    public boolean isArtifactTypeInheritsFrom(ArtifactTypeToken var1, ArtifactTypeToken var2);

    public Result setTransactionAssociatedArtifact(TransactionId var1, IAtsTeamWorkflow var2);

    public boolean isDeleted(ArtifactId var1);

    public TransactionId getTransactionId(IAtsWorkItem var1);

    default public boolean isInDb(IAtsWorkItem workItem) {
        return this.getTransactionId(workItem).isValid();
    }

    public CustomizeData getCustomizationByGuid(String var1);

    public boolean isProductionDb();

    public boolean isHistorical(IAtsObject var1);

    public JdbcService getJdbcService();

    default public Map<ArtifactId, ArtifactTypeToken> getArtifactTypes(Collection<ArtifactId> artIds) {
        String query = String.format(ART_TYPE_FROM_ID_QUERY, Collections.toString(artIds, (String)",", Id::getIdString));
        HashMap<ArtifactId, ArtifactTypeToken> artIdToType = new HashMap<ArtifactId, ArtifactTypeToken>();
        this.getJdbcService().getClient().runQuery(stmt -> {
            ArtifactTypeToken artifactTypeToken = artIdToType.put(ArtifactId.valueOf((Long)stmt.getLong("art_id")), this.getArtifactType(stmt.getLong("art_type_id")));
        }, query, new Object[0]);
        return artIdToType;
    }

    public boolean isOfType(IAtsObject var1, ArtifactTypeToken ... var2);

    public boolean inheritsFrom(ArtifactTypeToken var1, ArtifactTypeToken ... var2);

    public boolean isHistorical(ArtifactId var1);

    public boolean isReadOnly(IAtsWorkItem var1);

    public boolean isAccessControlWrite(IAtsWorkItem var1);
}

