/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.util;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.AtsConfigKey;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsUtil {
    public static final double DEFAULT_HOURS_PER_WORK_DAY = 8.0;
    public static final String DEFAULT_ATS_ID_VALUE = "0";
    public static final String USER_CREATION_DISABLED = "UserCreationDisabled2";
    public static final String ATS_CONFIG_ACTION_URL_KEY = "ActionUrl_26_0";
    public static final String ATS_DEFAULT_ACTION_URL = "/ats/ui/action/ID";
    public static final String SINGLE_SERVER_DEPLOYMENT = "single_server_deployment";

    public static boolean isInTest() {
        return Boolean.valueOf(System.getProperty("osee.isInTest"));
    }

    public static String doubleToI18nString(double d) {
        return AtsUtil.doubleToI18nString(d, false);
    }

    public static String doubleToI18nString(double d, boolean blankIfZero) {
        if (blankIfZero && d == 0.0) {
            return "";
        }
        if (d == 0.0) {
            return "0.00";
        }
        return String.format("%4.2f", d);
    }

    public static Dictionary<String, ?> hashTable(String key, String value) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(key, value);
        return table;
    }

    public static String getActionUrl(String atsIdOrid, AtsApi atsApi) {
        return AtsUtil.getActionUrl(atsIdOrid, ATS_DEFAULT_ACTION_URL, atsApi);
    }

    public static String getActionUrl(String atsIdOrid, String defaultUrl, AtsApi atsApi) {
        String actionUrl = AtsUtil.getBaseActionUiUrl(defaultUrl, atsApi);
        actionUrl = actionUrl.replaceFirst("ID", atsIdOrid);
        return actionUrl;
    }

    public static String getBaseActionUiUrl(String defaultUrl, AtsApi atsApi) {
        return atsApi.getConfigValue(ATS_CONFIG_ACTION_URL_KEY, defaultUrl);
    }

    public static String resolveAjaxToBaseApplicationServer(String html, AtsApi atsApi) {
        String basePath = atsApi.getConfigValue(AtsConfigKey.AJaxBasePath, atsApi.getApplicationServerBase());
        if (Strings.isValid((String)basePath)) {
            return html.replaceFirst("\\/ajax", String.valueOf(basePath) + "/ajax");
        }
        return html;
    }
}

