/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task.create;

import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.task.create.ChangeReportOptions;
import org.eclipse.osee.ats.api.task.create.CreateChangeReportTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.task.create.CreateTaskDefinition;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinition;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.RuleEventType;
import org.eclipse.osee.ats.api.workdef.StateToken;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CreateTasksDefinitionBuilder
extends NamedIdBase {
    protected CreateTasksDefinition createTasksDef;

    public CreateTasksDefinitionBuilder(Long id, String name) {
        super(id, name);
        this.createTasksDef = new CreateTasksDefinition(id, name);
    }

    public CreateTasksDefinition getCreateTasksDef() {
        return this.createTasksDef;
    }

    public CreateTasksDefinitionBuilder(AtsTaskDefToken taskSetToken) {
        this(taskSetToken.getId(), taskSetToken.getName());
    }

    public CreateTasksDefinitionBuilder andTransitionTo(StateToken toState) {
        this.createTasksDef.setRuleEvent(RuleEventType.TransitionTo);
        this.createTasksDef.setToState(toState.getName());
        return this;
    }

    public CreateTasksDefinitionBuilder andEventType(RuleEventType ruleEventType) {
        Conditions.assertFalse((ruleEventType == RuleEventType.TransitionTo ? 1 : 0) != 0, (String)"Invalid event type TransitionTo; use andTransitionTo()", (Object[])new Object[0]);
        this.createTasksDef.setRuleEvent(ruleEventType);
        return this;
    }

    public CreateTasksDefinitionBuilder andTask(String title, String desc, StateToken relatedToState, Long ... assigneeAccountId) {
        return this.andTask(title, desc, relatedToState, AtsWorkDefinitionTokens.WorkDef_Team_Default, assigneeAccountId);
    }

    public CreateTasksDefinitionBuilder andTask(String title, String desc, StateToken relatedToState, AtsWorkDefinitionToken workDef, Long ... assigneeAccountId) {
        Conditions.assertNotNullOrEmpty((String)title, (String)"title can not be empty", (Object[])new Object[0]);
        CreateTaskDefinition taskDef = new CreateTaskDefinition();
        taskDef.setTitle(title);
        if (Strings.isValid((String)desc)) {
            taskDef.setDescription(desc);
        }
        if (relatedToState != null && Strings.isValid((String)relatedToState.getName())) {
            taskDef.setRelatedToState(relatedToState.getName());
        }
        Long[] longArray = assigneeAccountId;
        int n = assigneeAccountId.length;
        int n2 = 0;
        while (n2 < n) {
            Long assigneAccountId = longArray[n2];
            taskDef.getAssigneeAccountIds().add(assigneAccountId);
            ++n2;
        }
        taskDef.setWorkDefTok(workDef);
        this.createTasksDef.getTasksDef().add(taskDef);
        return this;
    }

    public CreateTasksDefinitionBuilder andTask(String title) {
        return this.andTask(title, null, null, AtsWorkDefinitionTokens.WorkDef_Task_Default, new Long[0]);
    }

    public CreateTasksDefinitionBuilder andTask(String title, AtsWorkDefinitionToken taskWorkDef) {
        return this.andTask(title, null, null, taskWorkDef, new Long[0]);
    }

    public CreateChangeReportTasksDefinitionBuilder andChgRptBuilder() {
        if (this instanceof CreateChangeReportTasksDefinitionBuilder) {
            return (CreateChangeReportTasksDefinitionBuilder)this;
        }
        throw new OseeArgumentException("andChgReportBuilder only valid for CreateChangeReportTasksDefinitionBuilder", new Object[0]);
    }

    public ChangeReportOptions getChgRptOptions() {
        return this.createTasksDef.getChgRptOptions();
    }

    public void setChgRptOptions(ChangeReportOptions chgRptOptions) {
        this.createTasksDef.setChgRptOptions(chgRptOptions);
    }
}

