/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.Attribute;
import org.eclipse.osee.ats.api.workflow.AttributeKey;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

public class ActionOperations {
    private final AtsApi atsApi;
    private IAtsWorkItem workItem;
    private final IAtsUser asUser;
    private final OrcsApi orcsApi;

    public ActionOperations(IAtsUser asUser, IAtsWorkItem workItem, AtsApi atsApi, OrcsApi orcsApi) {
        this.asUser = asUser;
        this.workItem = workItem;
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public Attribute setActionAttributeByType(String id, String attrTypeIdOrKey, List<String> values) {
        Conditions.assertNotNull(values, (String)"values can not be null", (Object[])new Object[0]);
        IAtsChangeSet changes = this.atsApi.createChangeSet("set attr by type or key " + attrTypeIdOrKey);
        AttributeTypeString attrTypeId = null;
        if (attrTypeIdOrKey.equals(AttributeKey.Title.name())) {
            changes.setSoleAttributeValue(this.workItem, (AttributeTypeToken)CoreAttributeTypes.Name, values.iterator().next());
            attrTypeId = CoreAttributeTypes.Name;
        } else if (attrTypeIdOrKey.equals(AttributeKey.Priority.name())) {
            changes.setSoleAttributeValue(this.workItem, (AttributeTypeToken)AtsAttributeTypes.Priority, values.iterator().next());
            attrTypeId = AtsAttributeTypes.Priority;
        } else if (attrTypeIdOrKey.equals(AttributeKey.ColorTeam.name())) {
            changes.setSoleAttributeValue(this.workItem, (AttributeTypeToken)AtsAttributeTypes.ColorTeam, values.iterator().next());
            attrTypeId = AtsAttributeTypes.ColorTeam;
        } else if (attrTypeIdOrKey.equals(AttributeKey.IPT.name())) {
            changes.setSoleAttributeValue(this.workItem, (AttributeTypeToken)AtsAttributeTypes.IPT, values.iterator().next());
            attrTypeId = AtsAttributeTypes.IPT;
        } else if (attrTypeIdOrKey.equals(AttributeKey.State.name())) {
            String state = values.iterator().next();
            TransitionHelper helper = new TransitionHelper("Transition Workflow", Arrays.asList(this.workItem), state, new ArrayList(), "", changes, this.atsApi, new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
            helper.setTransitionUser(this.asUser);
            TransitionManager mgr = new TransitionManager((ITransitionHelper)helper);
            TransitionResults results = new TransitionResults();
            mgr.handleTransitionValidation(results);
            if (!results.isEmpty()) {
                throw new OseeArgumentException("Exception validating transition: " + results.toString(), new Object[0]);
            }
            mgr.handleTransition(results);
            if (!results.isEmpty()) {
                throw new OseeArgumentException("Exception transitioning: " + results.toString(), new Object[0]);
            }
            attrTypeId = AtsAttributeTypes.CurrentState;
        } else if (attrTypeIdOrKey.equals(AttributeKey.Version.name())) {
            if (!this.workItem.isTeamWorkflow()) {
                throw new OseeArgumentException("Not valid to set version for [%s]", new Object[]{this.workItem.getArtifactTypeName()});
            }
            IAtsVersion currVersion = this.atsApi.getVersionService().getTargetedVersion(this.workItem);
            if (values.isEmpty() && currVersion != null) {
                this.atsApi.getVersionService().removeTargetedVersion(this.workItem.getParentTeamWorkflow(), changes);
            } else if (Strings.isNumeric((String)values.iterator().next())) {
                String version = values.iterator().next();
                if (currVersion == null || !currVersion.getIdString().equals(version)) {
                    IAtsVersion newVer = null;
                    IAtsTeamDefinition teamDef = this.workItem.getParentTeamWorkflow().getTeamDefinition().getTeamDefinitionHoldingVersions();
                    for (IAtsVersion teamDefVer : this.atsApi.getVersionService().getVersions(teamDef)) {
                        if (!teamDefVer.getIdString().equals(version)) continue;
                        newVer = teamDefVer;
                        break;
                    }
                    if (newVer == null) {
                        throw new OseeArgumentException("Version id [%s] not valid for team ", new Object[]{version, teamDef.toStringWithId()});
                    }
                    this.atsApi.getVersionService().setTargetedVersion(this.workItem.getParentTeamWorkflow(), newVer, changes);
                }
            } else if (Strings.isValid((String)values.iterator().next())) {
                String version = values.iterator().next();
                if (currVersion == null || !currVersion.getName().equals(version)) {
                    IAtsVersion newVer = null;
                    IAtsTeamDefinition teamDef = this.workItem.getParentTeamWorkflow().getTeamDefinition().getTeamDefinitionHoldingVersions();
                    for (IAtsVersion teamDefVer : this.atsApi.getVersionService().getVersions(teamDef)) {
                        if (!teamDefVer.getName().equals(version)) continue;
                        newVer = teamDefVer;
                        break;
                    }
                    if (newVer == null) {
                        throw new OseeArgumentException("Version name [%s] not valid for team ", new Object[]{version, teamDef.toStringWithId()});
                    }
                    this.atsApi.getVersionService().setTargetedVersion(this.workItem.getParentTeamWorkflow(), newVer, changes);
                }
            }
        } else if (attrTypeIdOrKey.equals(AttributeKey.Originator.name())) {
            String accountId = values.iterator().next();
            if (!Strings.isNumeric((String)accountId)) {
                IAtsUser originator = this.atsApi.getUserService().getUserByAccountId(Long.valueOf(accountId));
                if (originator == null) {
                    throw new OseeArgumentException("No user with account id [%s]", new Object[]{accountId});
                }
                this.atsApi.getActionFactory().setCreatedBy(this.workItem, originator, true, this.workItem.getCreatedDate(), changes);
            }
        } else if (attrTypeIdOrKey.equals(AttributeKey.assocArt.name())) {
            if (Strings.isNumeric((String)values.get(0)) && (attrTypeId = this.getAttributeType(values.get(0))) != null) {
                values.remove(0);
                changes.setSoleAttributeValue(this.workItem, (AttributeTypeToken)attrTypeId, Collections.toString((String)",", values));
            }
        } else if (attrTypeIdOrKey.equals(AttributeKey.Assignee.name())) {
            String accountIdOrName = values.iterator().next();
            if (Strings.isNumeric((String)accountIdOrName)) {
                IAtsUser assignee = this.atsApi.getUserService().getUserByAccountId(Long.valueOf(accountIdOrName));
                if (assignee == null) {
                    throw new OseeArgumentException("No user with account id [%s]", new Object[]{accountIdOrName});
                }
                this.workItem.getStateMgr().addAssignee(assignee);
                changes.add((Object)this.workItem);
            } else {
                IAtsUser assignee = this.atsApi.getUserService().getUserByName(accountIdOrName);
                if (assignee == null) {
                    throw new OseeArgumentException("No user with user name [%s]", new Object[]{accountIdOrName});
                }
                this.workItem.getStateMgr().addAssignee(assignee);
                changes.add((Object)this.workItem);
            }
        } else {
            attrTypeId = this.getAttributeType(attrTypeIdOrKey);
            if (attrTypeId != null) {
                changes.setAttributeValuesAsStrings((IAtsObject)this.workItem, (AttributeTypeId)attrTypeId, values);
            }
        }
        changes.executeIfNeeded();
        this.workItem = this.atsApi.getQueryService().getWorkItem(id);
        if (attrTypeId != null) {
            return this.getActionAttributeValues((AttributeTypeToken)attrTypeId, this.workItem);
        }
        return null;
    }

    private AttributeTypeToken getAttributeType(String id) {
        return (AttributeTypeToken)this.orcsApi.getOrcsTypes().getAttributeTypes().get(Long.valueOf(id));
    }

    public Attribute getActionAttributeValues(String attrTypeId, IAtsWorkItem workItem) {
        return this.getActionAttributeValues(this.getAttributeType(attrTypeId), workItem);
    }

    private Attribute getActionAttributeValues(AttributeTypeToken attrType, IAtsWorkItem workItem) {
        Attribute attribute = new Attribute();
        attribute.setArtId((ArtifactId)workItem.getStoreObject());
        attribute.setAttrTypeId((AttributeTypeId)attrType);
        for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)workItem, attrType)) {
            attribute.addAttribute(attr);
        }
        return attribute;
    }

    public Collection<ArtifactToken> setByArtifactToken(IAtsWorkItem workItem, String changeType, Collection<ArtifactToken> artifacts) {
        IAtsChangeSet changes;
        IAtsChangeSet changes2;
        if (changeType.equals(AttributeKey.Assignee.name())) {
            if (artifacts.isEmpty()) {
                changes2 = this.atsApi.createChangeSet("Clear assignees", this.asUser);
                this.atsApi.getWorkItemService().clearAssignees(workItem, changes2);
                changes2.executeIfNeeded();
            } else {
                HashSet<IAtsUser> assignees = new HashSet<IAtsUser>();
                for (ArtifactToken userArt : artifacts) {
                    IAtsUser user = this.atsApi.getUserService().getUserByArtifactId((ArtifactId)userArt);
                    Conditions.assertNotNull((Object)user, (String)"Artifact %s is not a User", (Object[])new Object[]{userArt.toStringWithId()});
                    assignees.add(user);
                }
                changes = this.atsApi.createChangeSet("Clear assignees", this.asUser);
                this.atsApi.getWorkItemService().setAssignees(workItem, assignees, changes);
                changes.executeIfNeeded();
            }
        }
        if (changeType.equals(AttributeKey.Version.name())) {
            if (workItem.isTeamWorkflow()) {
                throw new OseeArgumentException("WorkItem %s is not a Team Workflow", new Object[]{workItem.toStringWithId()});
            }
            if (artifacts.size() > 1) {
                throw new OseeArgumentException("Can not set more than one targeted version for %s", new Object[]{workItem.toStringWithId()});
            }
            if (artifacts.isEmpty()) {
                changes2 = this.atsApi.createChangeSet("Clear targeted version", this.asUser);
                this.atsApi.getVersionService().removeTargetedVersion((IAtsTeamWorkflow)workItem, changes2);
                changes2.executeIfNeeded();
            } else {
                IAtsVersion version = this.atsApi.getVersionService().getById((ArtifactId)artifacts.iterator().next());
                Conditions.assertNotNull((Object)version, (String)"No version found from artifact %s", (Object[])new Object[]{artifacts.iterator().next()});
                changes = this.atsApi.createChangeSet("Set targeted version", this.asUser);
                this.atsApi.getVersionService().setTargetedVersion((IAtsTeamWorkflow)workItem, version, changes);
                changes.executeIfNeeded();
            }
        }
        return artifacts;
    }
}

