/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.task.AbstractAtsTaskService;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.rest.internal.workitem.CreateTasksOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.OrcsApi;

public class AtsTaskService
extends AbstractAtsTaskService {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public AtsTaskService(AtsApi atsApi, OrcsApi orcsApi) {
        super(atsApi);
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData, XResultData results) {
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet(newTaskData.getCommitComment(), AtsCoreUsers.SYSTEM_USER);
        return this.createTasks(newTaskData, changes, results);
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData, IAtsChangeSet changes, XResultData results) {
        return this.createTasks(newTaskData, changes, results, new HashMap<Long, IAtsTeamWorkflow>());
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData, IAtsChangeSet changes, XResultData results, Map<Long, IAtsTeamWorkflow> idToTeamWf) {
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        CreateTasksOperation operation = new CreateTasksOperation(newTaskData, this.atsApi, this.orcsApi, results);
        operation.setIdToTeamWf(idToTeamWf);
        operation.validate();
        if (results.isSuccess()) {
            operation.run(changes);
            if (results.isSuccess()) {
                for (JaxAtsTask task : operation.getTasks()) {
                    tasks.add(this.atsApi.getWorkItemService().getTask(this.atsApi.getQueryService().getArtifact(task.getId())));
                }
            }
        }
        return tasks;
    }

    public Collection<IAtsTask> createTasks(NewTaskDatas newTaskDatas) {
        CreateTasksOperation operation = new CreateTasksOperation(newTaskDatas, this.atsApi, this.orcsApi, new XResultData());
        XResultData results = operation.validate();
        if (results.isErrors()) {
            throw new OseeStateException("Error validating task creation - " + results.toString(), new Object[0]);
        }
        operation.run();
        if (results.isErrors()) {
            throw new OseeStateException("Error creating tasks - " + results.toString(), new Object[0]);
        }
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        for (JaxAtsTask task : operation.getTasks()) {
            tasks.add(this.atsApi.getWorkItemService().getTask(this.atsApi.getQueryService().getArtifact(task.getId())));
        }
        return tasks;
    }

    public Collection<IAtsTask> createTasks(IAtsTeamWorkflow teamWf, List<String> titles, List<IAtsUser> assignees, Date createdDate, IAtsUser createdBy, String relatedToState, String taskWorkDef, Map<String, List<Object>> attributes, IAtsChangeSet changes) {
        NewTaskData tasks = this.atsApi.getTaskService().getNewTaskData(teamWf, titles, assignees, createdDate, createdBy, relatedToState, taskWorkDef, attributes, changes.getComment());
        return this.createTasks(tasks, changes, new XResultData());
    }
}

