/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.task.AtsTaskEndpointApi;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.JaxAtsTasks;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.rest.internal.task.CreateChangeReportTasksOperation;
import org.eclipse.osee.ats.rest.internal.workitem.CreateTasksOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.OrcsApi;

public class AtsTaskEndpointImpl
implements AtsTaskEndpointApi {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public AtsTaskEndpointImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="chgRpt")
    public ChangeReportTaskData create(ChangeReportTaskData changeReportTaskData) {
        CreateChangeReportTasksOperation operation = new CreateChangeReportTasksOperation(changeReportTaskData, this.atsApi);
        return operation.run();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JaxAtsTasks create(NewTaskDatas newTaskDatas) {
        JaxAtsTasks tasks;
        CreateTasksOperation operation = new CreateTasksOperation(newTaskDatas, this.atsApi, this.orcsApi, new XResultData());
        XResultData results = operation.validate();
        if (results.isErrors()) {
            tasks = new JaxAtsTasks();
            tasks.setResults(results);
        }
        operation.run();
        tasks = new JaxAtsTasks();
        tasks.getTasks().addAll(operation.getTasks());
        return tasks;
    }

    @GET
    @Path(value="{taskId}")
    @Produces(value={"application/json"})
    public JaxAtsTask get(@PathParam(value="taskId") long taskId) {
        IAtsWorkItem task = (IAtsWorkItem)this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).isOfType(new WorkItemType[]{WorkItemType.Task}).andIds(new Long[]{taskId}).getResults().getOneOrDefault((Object)IAtsWorkItem.SENTINEL);
        if (task.getId().equals(IAtsWorkItem.SENTINEL.getId())) {
            throw new OseeArgumentException("No Task found with id %d", new Object[]{taskId});
        }
        JaxAtsTask jaxAtsTask = CreateTasksOperation.createNewJaxTask(task.getId(), this.atsApi);
        return jaxAtsTask;
    }

    @DELETE
    @Path(value="{taskId}")
    public void delete(@PathParam(value="taskId") long taskId) {
        IAtsWorkItem task = (IAtsWorkItem)this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).isOfType(new WorkItemType[]{WorkItemType.Task}).andIds(new Long[]{taskId}).getResults().getOneOrDefault((Object)IAtsWorkItem.SENTINEL);
        if (!task.getId().equals(IAtsWorkItem.SENTINEL.getId())) {
            IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Delete Task", AtsCoreUsers.SYSTEM_USER);
            changes.deleteArtifact(task);
            changes.execute();
        }
    }
}

