/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workflow.AttributeKey;
import org.eclipse.osee.ats.api.workflow.attr.AtsAttributeEndpointApi;
import org.eclipse.osee.ats.api.workflow.attr.AtsAttributes;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.data.EnumEntry;

@Path(value="attr")
public final class AtsAttributeEndpointImpl
implements AtsAttributeEndpointApi {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;
    @Context
    private HttpHeaders httpHeaders;

    public AtsAttributeEndpointImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    @GET
    @Produces(value={"application/json"})
    public AtsAttributes get() {
        AtsAttributes attrs = new AtsAttributes();
        AttributeKey[] attributeKeyArray = AttributeKey.values();
        int n = attributeKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeKey key = attributeKeyArray[n2];
            attrs.add(key.name(), key.name(), key.getUrl().equals("N/A") ? key.getUrl() : String.valueOf(System.getProperty("OseeApplicationServer")) + key.getUrl());
            ++n2;
        }
        AttributeTypes attrTypes = this.orcsApi.getOrcsTypes().getAttributeTypes();
        for (AttributeTypeToken attrType : attrTypes.getAll()) {
            if (!attrTypes.isEnumerated((AttributeTypeId)attrType)) continue;
            attrs.add(attrType.getIdString(), attrType.getName(), String.valueOf(System.getProperty("OseeApplicationServer")) + "/ats/attr/" + attrType.getIdString() + "/");
        }
        return attrs;
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/json"})
    public List<String> getValidValues(@PathParam(value="id") String id) {
        LinkedList<String> values = new LinkedList<String>();
        if (id.equals(AttributeKey.Assignee.name()) || id.equals(AttributeKey.Originator.name())) {
            List active = this.atsApi.getUserService().getUsers(Active.Active);
            for (IAtsUser user : active) {
                values.add(user.getName());
            }
        } else if (id.equals(AttributeKey.ColorTeam.name())) {
            this.getEnumValues(values, AtsAttributeTypes.ColorTeam.getId());
        } else if (id.equals(AttributeKey.IPT.name())) {
            this.getEnumValues(values, AtsAttributeTypes.IPT.getId());
        } else if (id.equals(AttributeKey.Priority.name())) {
            this.getEnumValues(values, AtsAttributeTypes.Priority.getId());
        } else if (Strings.isNumeric((String)id)) {
            this.getEnumValues(values, Long.valueOf(id));
        }
        if (!values.isEmpty()) {
            Collections.sort(values);
        }
        return values;
    }

    private void getEnumValues(List<String> values, Long id) {
        AttributeTypeToken attrType;
        AttributeTypes attrTypes = this.orcsApi.getOrcsTypes().getAttributeTypes();
        if (attrTypes.isEnumerated((AttributeTypeId)(attrType = (AttributeTypeToken)attrTypes.get(id)))) {
            EnumEntry[] enumEntryArray = attrTypes.getEnumType((AttributeTypeId)attrType).values();
            int n = enumEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                EnumEntry entry = enumEntryArray[n2];
                values.add(entry.getName());
                ++n2;
            }
        }
    }
}

