/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ApplicabilityData;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.VariantDefinition;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;

@Path(value="applic")
public interface ApplicabilityEndpoint {
    @GET
    @Produces(value={"application/json"})
    public Collection<ApplicabilityToken> getApplicabilityTokens();

    @GET
    @Path(value="artifact/{artId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ApplicabilityToken getApplicabilityToken(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="artifact/reference/{artId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ApplicabilityId> getApplicabilitiesReferenced(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="artifact/reference/token/{artId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getApplicabilityReferenceTokens(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="view/{viewId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getViewApplicabilityTokens(@PathParam(value="viewId") ArtifactId var1);

    @GET
    @Path(value="view")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getViews();

    @GET
    @Path(value="feature-data")
    @Produces(value={"application/json"})
    public List<FeatureDefinition> getFeatureDefinitionData();

    @GET
    @Path(value="feature/{feature}")
    @Produces(value={"application/json"})
    public FeatureDefinition getFeature(@PathParam(value="feature") String var1);

    @PUT
    @Path(value="feature/{action}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData createUpdateFeature(FeatureDefinition var1, @PathParam(value="action") String var2);

    @DELETE
    @Path(value="feature/{feature}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData deleteFeature(@PathParam(value="feature") ArtifactId var1);

    @GET
    @Path(value="variant/{variant}")
    @Produces(value={"application/json"})
    public VariantDefinition getVariant(@PathParam(value="variant") String var1);

    @PUT
    @Path(value="variant/{action}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData createUpdateVariant(VariantDefinition var1, @PathParam(value="action") String var2);

    @DELETE
    @Path(value="variant/{variant}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData deleteVariant(@PathParam(value="variant") String var1);

    @PUT
    @Path(value="variant/{variant}/feature/{feature}/applic/{applicability}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData setApplicability(@PathParam(value="variant") ArtifactId var1, @PathParam(value="feature") ArtifactId var2, @PathParam(value="applicability") String var3);

    @GET
    @Path(value="change")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchId> getAffectedBranches(@QueryParam(value="injectionDateMs") Long var1, @QueryParam(value="removalDateMs") @DefaultValue(value="-1") Long var2, List<ApplicabilityId> var3);

    @PUT
    @Path(value="artifacts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> var1);

    @GET
    @Path(value="change")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchId> getAffectedBranches(@QueryParam(value="injectiontx") TransactionId var1, @QueryParam(value="removaltx") @DefaultValue(value="-1") TransactionId var2, List<ApplicabilityId> var3);

    @GET
    @Path(value="table")
    @Produces(value={"text/html"})
    public String getViewTable(@QueryParam(value="filter") String var1);

    @PUT
    @Path(value="{applicId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken setApplicability(@PathParam(value="applicId") ApplicabilityId var1, List<? extends ArtifactId> var2);

    @PUT
    @Path(value="artifact/reference")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken setApplicabilityReference(List<ApplicabilityData> var1);

    @GET
    @Path(value="versionConfig/{version}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ArtifactId getVersionConfig(@PathParam(value="version") ArtifactId var1);

    @POST
    @Path(value="view")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ArtifactToken createView(String var1);

    @POST
    @Path(value="view/{sourceView}/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken copyView(@PathParam(value="sourceView") ArtifactId var1, String var2);

    @POST
    @Path(value="view/{viewId}/applic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData createApplicabilityForView(@PathParam(value="viewId") ArtifactId var1, String var2);

    @POST
    @Path(value="update-from-parent")
    public void addMissingApplicabilityFromParentBranch();

    @GET
    @Path(value="access")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData isAccess();
}

